package w83b.w83bManager;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bCentroTrabajoBean;
import w83b.w83bBeans.W83bDelegadosBean;
import w83b.w83bBeans.W83bDelegadosEqualsBean;
import w83b.w83bBeans.W83bDelegadosIncidenciasEqualsBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bDocBeanIncidencia;
import w83b.w83bBeans.W83bEscrutinioBean;
import w83b.w83bBeans.W83bEscrutinioEqualsBean;
import w83b.w83bBeans.W83bIncidenciaHistorialActaBean;
import w83b.w83bBeans.W83bIncidenciaImpugnacionBean;
import w83b.w83bBeans.W83bIncidenciasBean;
import w83b.w83bBeans.W83bListaDelegadosBean;
import w83b.w83bBeans.W83bListaDiferenciasBean;
import w83b.w83bBeans.W83bListaDiferenciasEqualsBean;
import w83b.w83bBeans.W83bListaEscrutiniosBean;
import w83b.w83bBeans.W83bNuevaIncidenciasBean;
import w83b.w83bBeans.W83bPapeletasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasTipoSustitucionBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bDateUtils;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistro;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistroException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;


// TODO: Auto-generated Javadoc
/**
 * The Class W83bIncidencias.
 */
public class W83bIncidencias implements W83bIIncidencias {
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#buscarIncidencias(w83b.w83bBeans.W83bIncidenciasBean)
	 */
	public java.util.List buscarIncidencias(w83b.w83bBeans.W83bIncidenciasBean param) throws Exception{

		List listaIncidencias = W83bFactoriaDAO.getIncidenciasDAO().buscarIncidencias(param,false);
		
		return listaIncidencias;			
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#contarIncidencias(w83b.w83bBeans.W83bIncidenciasBean)
	 */
	public java.lang.Integer contarIncidencias(w83b.w83bBeans.W83bIncidenciasBean param) throws Exception{
		
		return new Integer(W83bFactoriaDAO.getIncidenciasDAO().buscarIncidencias(param,true).get(0).toString());	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public java.util.List buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception{
		List listaIncidencias = W83bFactoriaDAO.getIncidenciasDAO().buscarDelegadosIncidencias(param);
		
		return listaIncidencias;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#noExisteDniDelegados(java.util.List)
	 */
	public java.util.List noExisteDniDelegados(java.util.List param) throws Exception{
		String territorioActa = (String)param.get(0);
		String anyoActa = (String)param.get(1);
		String numActa = (String)param.get(2);
		
		List listaRespuesta = new ArrayList();
		W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)param.get(param.size()-1);
		param.remove(param.size()-1);
		
		for(int i = 3,size = param.size();i<size;i++){
			String dni = (String)param.get(i);
			HashMap mapa = new HashMap();//NOPMD
			mapa.put(dni.split("_%_")[0]+"_delegado",dni.split("_%_")[1]);//NOPMD
			
			if(W83bFactoriaDAO.getIncidenciasDAO().noExisteDniDelegados(territorioActa,
																		anyoActa, numActa, dni.split("_*_")[0],usuario,null)){
			//para adecuarme al nombre de la funcin meto en caso de que existe "false" en la respuesta
				mapa.put(dni.split("_%_")[0],"false");
			}else{
				mapa.put(dni.split("_%_")[0],"true");
			}
			
			if(W83bFactoriaDAO.getIncidenciasDAO().noExisteDniDelegados(territorioActa,
					anyoActa, numActa, dni.split("_*_")[0],usuario,dni.split("_*_")[4])){
				//para adecuarme al nombre de la funcin meto en caso de que existe "false" en la respuesta
				mapa.put(dni.split("_%_")[0]+"_fechaEntrada","falseFechaEntrada");
			}else{
				mapa.put(dni.split("_%_")[0]+"_fechaEntrada","trueFechaEntrada");
			}
			
			
			listaRespuesta.add(mapa);
		}
		
		return listaRespuesta;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#existeActa(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String existeActa(W83bNuevaIncidenciasBean incidencia)throws Exception{
		boolean existeActaTablaIncidencias = false;
		
		
		List existeActaTablaActas = new ArrayList();
		
		String version = W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidadaNoValidadaDescartada(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero());
		String versionActaParcial = version;
		
		String versionActaReal = "";
		
//		String actaNoRegistrada = "";
		
		if(null!=version){
			incidencia.setActaVersion(version);
			//incidencia.setActaVersion(String.valueOf((Integer.parseInt(incidencia.getActaVersion())+1)));
			
			existeActaTablaIncidencias = W83bFactoriaDAO.getIncidenciasDAO().existeActaIncidencia(incidencia);
			existeActaTablaActas = W83bFactoriaDAO.getIncidenciasDAO().existeActaTablaActas(incidencia);
			
			versionActaReal = W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidada(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero());
			if(null==versionActaReal){
				versionActaReal = "";
			}
			
		}else{
			return "-2";
		}
		if (!(existeActaTablaActas.size()>0)){
			return "-2";			
		}else{
			HashMap mapa = (HashMap)existeActaTablaActas.get(0);
			String versionNoValidadaStr = W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaNoValidado(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero());
			if(existeActaTablaIncidencias&&(null==mapa.get(W83bActasBD.numTotalActa)
					||(null!=mapa.get(W83bActasBD.numTotalActa)&&StringUtils.isEmpty((String)mapa.get(W83bActasBD.numTotalActa).toString())))
					&&StringUtils.isNotEmpty(versionNoValidadaStr)){
				return "-1&&"+versionNoValidadaStr;
			
			}else if((/*existeActaTablaIncidencias&&*/((null==mapa.get(W83bActasBD.numRegDefinitivo)))
					||(null!=mapa.get(W83bActasBD.numRegDefinitivo)&&StringUtils.isEmpty(mapa.get(W83bActasBD.numRegDefinitivo).toString())))&&
					(null==mapa.get(W83bActasBD.numTotalActa)||null!=mapa.get(W83bActasBD.numTotalActa)
					&&StringUtils.isEmpty((String)mapa.get(W83bActasBD.numTotalActa).toString()))){
				
				return "-6&&"+version;
			
			}else {
				if(null!=mapa.get(W83bActasBD.numTotalActa)
						&&StringUtils.isNotEmpty((String)mapa.get(W83bActasBD.numTotalActa).toString())){
					version = W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidadaNoValidada(incidencia.getActaTerritorio(),mapa.get(W83bActasBD.anyoTotalActa).toString(),(String)mapa.get(W83bActasBD.numTotalActa).toString());
					if(null!=version){
						W83bNuevaIncidenciasBean incidenciaTemp = new W83bNuevaIncidenciasBean();
						incidenciaTemp.setActaAnyo(mapa.get(W83bActasBD.anyoTotalActa).toString());
						incidenciaTemp.setActaTerritorio(incidencia.getActaTerritorio());
						incidenciaTemp.setActaNumero(mapa.get(W83bActasBD.numTotalActa).toString());
						incidenciaTemp.setActaVersion(version);
						incidenciaTemp.setActaVersion(String.valueOf((Integer.parseInt(incidenciaTemp.getActaVersion())+1)));
						boolean existeActaTablaIncidenciasTotal = W83bFactoriaDAO.getIncidenciasDAO().existeActaIncidenciaNoValidadaAnteriorPorVersion(incidenciaTemp);
						String mensaje = "";
//						String mensajeIncidenciaAnteriorNoValidada = "";
						String mensajeIncidenciaParcialAnteriorNoValidada = "";
						if(existeActaTablaIncidencias){
							mensaje = Q70GestorMensajesi18n.getSingleton().getMessage("w83brecursosErrores","error.mensaje.nActaRepetida",incidencia.getIdioma(),null);
						}else{
							mensaje = "null";
						}
						mensaje = new StringBuffer(W83bClsConstantes.UNO)//NOPMD
						.append(mensaje).append("__").toString();
						if(existeActaTablaIncidenciasTotal){
							mensaje = new StringBuffer(W83bClsConstantes.UNO)//NOPMD
							.append(mensaje)
							.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83brecursosErrores","error.mensaje.nActaTotalNoValida",incidencia.getIdioma(),new String[]{
								new StringBuffer(W83bClsConstantes.UNO).append(incidencia.getActaTerritorio()).append("/")
								.append(mapa.get(W83bActasBD.anyoTotalActa).toString()).append("/")
								.append(mapa.get(W83bActasBD.numTotalActa).toString()).toString()
							})).toString();//NOPMD
						}else{
							mensaje = new StringBuffer(W83bClsConstantes.UNO).append(mensaje).append("null").toString();//NOPMD						
						}
						String versionNoValidada = W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidadaNoValidada(incidencia.getActaTerritorio(),mapa.get(W83bActasBD.anyoTotalActa).toString(),(String)mapa.get(W83bActasBD.numTotalActa).toString());
						String versionActaParcialNoValidada = W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidadaNoValidada(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero());
						if(null!=versionNoValidada
								){
//							mensajeIncidenciaAnteriorNoValidada = "hya incidencia anterior no validada";
							version = versionNoValidada;
						}
						if(W83bFactoriaDAO.getIncidenciasDAO().existeActaIncidenciaNoValidadaAnteriorPorVersion(incidencia)){
							mensajeIncidenciaParcialAnteriorNoValidada = "true";
							versionActaParcial = versionActaParcialNoValidada;
						}else{
							mensajeIncidenciaParcialAnteriorNoValidada = "null";
						}
						StringBuffer respuesta = new StringBuffer(W83bClsConstantes.UNO).append("-4___")
						.append(mapa.get(W83bActasBD.anyoTotalActa))
						.append(mapa.get(W83bActasBD.numTotalActa))	
						.append("__").append(version)
						.append("__").append(versionActaParcial)
						.append("__").append(mensaje)
						.append("__").append(mensajeIncidenciaParcialAnteriorNoValidada);
						
						if((/*existeActaTablaIncidencias&&*/(null==mapa.get(W83bActasBD.numRegDefinitivo)))
								||(null!=mapa.get(W83bActasBD.numRegDefinitivo)&&StringUtils.isEmpty((String)mapa.get(W83bActasBD.numRegDefinitivo).toString()))){
							respuesta.append("__").append("-7");
						}
						
							return respuesta
							.toString();

					}else{
						StringBuffer respuesta = new StringBuffer(W83bClsConstantes.UNO).append("-4___")
						.append(mapa.get(W83bActasBD.anyoTotalActa))
						.append(mapa.get(W83bActasBD.numTotalActa))	
						.append("__")
						.append(version).append("__").append(versionActaParcial);
						if((/*existeActaTablaIncidencias&&*/(null==mapa.get(W83bActasBD.numRegDefinitivo)))
								||(null!=mapa.get(W83bActasBD.numRegDefinitivo)&&StringUtils.isEmpty((String)mapa.get(W83bActasBD.numRegDefinitivo).toString()))){
							respuesta.append("__").append("-7");
						}
						
						return respuesta.toString();					
					}
				}
			}	
		
		}
		
		return versionActaReal;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#existeActa(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public W83bNuevaIncidenciasBean devolverNCentroTrabajo(W83bNuevaIncidenciasBean incidencia)throws Exception{
		
		
		String centroTrabajo = W83bFactoriaDAO.getActasDAO().buscarCentroTrabajoActa(incidencia.getActaTerritorio(),
				incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion());
		
		
		W83bCentroTrabajoBean param = new W83bCentroTrabajoBean();
		param.setCodCentroTrabajo(centroTrabajo);
		
		incidencia.setCentroTrabajo((W83bCentroTrabajoBean)(W83bFactoriaDAO.getMantenimientosDAO().buscarCentroTrabajo(param)).get(0));
		
		
		return incidencia;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#existeActa(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public HashMap recuperarEscrutinioDiferencias(java.util.List param)throws Exception{
		String territorioActa = (String)param.get(0);
		String anyoActa = (String)param.get(1);
		String numActa = (String)param.get(2);
		String versionActa = (String)param.get(3);
		String idioma = (String)param.get(4);
		
		HashMap hashRespuesta = new HashMap();
		
			
		hashRespuesta.put("diferencias",W83bFactoriaDAO.getIncidenciasDAO().encontrarDiferenciasActa(
				territorioActa,anyoActa,numActa,versionActa,idioma));
		
		hashRespuesta.put("escrutinio",W83bFactoriaDAO.getIncidenciasDAO().obtenerEscrutinio(
				territorioActa,anyoActa,numActa,versionActa,idioma));
		
		hashRespuesta.put("busqRealizada","true");
		
		return hashRespuesta;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#existeIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String existeIncidencia(W83bNuevaIncidenciasBean incidencia)throws Exception{
		boolean existeIncidencia = false;
		
		existeIncidencia = W83bFactoriaDAO.getIncidenciasDAO().existeIncidencia(incidencia);
		
		if(existeIncidencia){
			return "-1";		
		}		
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#cargaTiposDocumentoIncidencias(java.util.HashMap)
	 */
	public List cargaTiposDocumentoIncidencias(HashMap param) throws Exception{
		
		return W83bFactoriaDAO.getIncidenciasDAO().cargaTiposDocumentoIncidencias(param);
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#validarFechaEntradaIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String validarFechaEntradaIncidencia(W83bNuevaIncidenciasBean incidencia)throws Exception{
		String fechaEleccion = "";
		String fechaEntradaAnterior = "";
		String fechaEntradaPosterior = "";
		String cierre = "";
		String version = null;
		String versionActual = null;
		String versionValidadaNoValidada = null;
		if (incidencia.getFecEntrada()!=null && !incidencia.getFecEntrada().equals("")){
			java.util.Date dateEntr=W83bDateUtil.getInstance().stringToDateIdioma(incidencia.getFecEntrada(),incidencia.getIdioma());
			java.util.Date dateAct=W83bDateUtil.getInstance().stringToDateIdioma(W83bDateUtils.getToday(),incidencia.getIdioma());
			
			if (dateEntr.after(dateAct)){
				return "-3"; 
			}
		}
		if(StringUtils.isNotEmpty(incidencia.getActaAnyo())&&
				StringUtils.isNotEmpty(incidencia.getActaNumero())&&
				StringUtils.isEmpty(incidencia.getActaVersion())
				){
			version = W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidada(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero());
			
			versionActual = W83bFactoriaDAO.getIncidenciasDAO().versionIncidencia(incidencia.getActaTerritorio(),incidencia.getIncidenciaAnyo(),incidencia.getIncidenciaNumero());
			
			if(null!=versionActual){
				versionValidadaNoValidada = W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaAnteriorValidadaNoValidadaNoActual(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),versionActual);
			}else{
				versionValidadaNoValidada = "0";
			}
		}
		
		W83bNuevaIncidenciasBean incidenciaAnteriorNoValidada = new W83bNuevaIncidenciasBean(incidencia);
		
		if(null!=version&&
				null!=versionValidadaNoValidada){
			incidencia.setActaVersion(version);
			incidenciaAnteriorNoValidada.setActaVersion(versionValidadaNoValidada);
			
			if(-1!=incidencia.getValidaciones().indexOf("ValidacionFechaEntrada")){
				fechaEleccion = W83bFactoriaDAO.getIncidenciasDAO().validarFechaEntradaIncidencia(incidenciaAnteriorNoValidada);
				fechaEntradaAnterior = W83bFactoriaDAO.getIncidenciasDAO().validarFechaEntradaIncidenciaAnterior(incidenciaAnteriorNoValidada);
				
				
				java.util.Date dateEleccion = W83bDateUtil.getInstance().stringToDateIdioma(fechaEleccion,incidenciaAnteriorNoValidada.getIdioma());
				java.util.Date dateEntrada= W83bDateUtil.getInstance().stringToDateIdioma(incidenciaAnteriorNoValidada.getFecEntrada(),incidenciaAnteriorNoValidada.getIdioma());
				java.util.Date dateEntradaAnterior = null;
				Calendar calendarioDateEntradaAnterior = Calendar.getInstance();
				if(-1!=incidencia.getValidaciones().indexOf("true")&&null!=fechaEntradaAnterior){
					dateEntradaAnterior = W83bDateUtil.getInstance().stringToDateIdioma(fechaEntradaAnterior,incidenciaAnteriorNoValidada.getIdioma());
					calendarioDateEntradaAnterior.setTimeInMillis(dateEntradaAnterior.getTime());			
				}
	
				Calendar calendario = Calendar.getInstance();
				calendario.setTimeInMillis(dateEleccion.getTime());			
				calendario.add(Calendar.YEAR, 4);
				
					
				if(calendario.getTime().before(dateEntrada)){
					return "-1";		
				}
				
				if(-1!=incidenciaAnteriorNoValidada.getValidaciones().indexOf("true")
						&&null!=dateEntradaAnterior&&calendarioDateEntradaAnterior.getTime().after(dateEntrada)){
					return "-2";
				}
				
				if(-1!=incidencia.getValidaciones().indexOf("ValidarFechaEntradaIncidenciasPosteriores")){
					java.util.Date dateEntradaPosterior = null;
					Calendar calendarioDateEntradaPosterior = Calendar.getInstance();
					fechaEntradaPosterior = W83bFactoriaDAO.getIncidenciasDAO().validarFechaEntradaIncidenciaPosterior(incidencia,versionActual);
					if(StringUtils.isNotEmpty(fechaEntradaPosterior)){
						dateEntradaPosterior = W83bDateUtil.getInstance().stringToDateIdioma(fechaEntradaPosterior,incidencia.getIdioma());
						calendarioDateEntradaPosterior.setTimeInMillis(dateEntradaPosterior.getTime());
						
						if(null!=dateEntradaPosterior
								&&calendarioDateEntradaPosterior.getTime().before(dateEntrada)){
							return "-6";
						}
					}
				}
			}
		}
		if(-1!=incidencia.getValidaciones().indexOf("SiCierre")){
			cierre = W83bFactoriaDAO.getIncidenciasDAO().buscarCierre(incidencia,false);
			if(W83bClsConstantes.CONSTANTE_SI.equals(cierre)){
				return "-3";				
			}
		}
		if(-1!=incidencia.getValidaciones().indexOf("ValidarFechaValidacion")){
			String fechaValidacionAnterior = W83bFactoriaDAO.getIncidenciasDAO().validarFechaValidacionIncidenciaAnterior(incidencia);
			java.util.Date dateValidacionAnterior = null;
			Calendar calendarioDateValidacionAnterior = Calendar.getInstance();
			java.util.Date dateValidacion= W83bDateUtil.getInstance().stringToDateIdioma(incidencia.getFecValidacion(),incidencia.getIdioma());
			
			if(null!=fechaValidacionAnterior){
				dateValidacionAnterior = W83bDateUtil.getInstance().stringToDateIdioma(fechaValidacionAnterior,incidencia.getIdioma());
				calendarioDateValidacionAnterior.setTimeInMillis(dateValidacionAnterior.getTime());			
			}
			
			if(null!=dateValidacionAnterior&&calendarioDateValidacionAnterior.getTime().after(dateValidacion)){
				return "-4";				
			}
		}
		if(null!=version&&
				null!=versionValidadaNoValidada){
			if(-1!=incidencia.getValidaciones().indexOf("ValidarIncidenciaNoValidadaAnterior")){
				
				boolean existeActaNoValidada = W83bFactoriaDAO.getIncidenciasDAO().existeActaIncidenciaNoValidadaAnterior(incidencia);
				if(existeActaNoValidada){
					return "-5";
				}
			}
			if(-1!=incidencia.getValidaciones().indexOf("DescartarIncidenciaConNoValidadasPosterior")){
				
				boolean existeActaNoValidada = W83bFactoriaDAO.getIncidenciasDAO().existeActaIncidenciaNoValidadaPosterior(incidencia);
				if(existeActaNoValidada){
					return "-6";
				}
			}
		}
			return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#insertarIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String insertarIncidencia(W83bNuevaIncidenciasBean incidencia)throws Exception{
		
			
		incidencia.setActaVersion(W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidadaNoValidada(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero()));
		String versionVieja = incidencia.getActaVersion();
		incidencia.setActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerActas(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
		if(StringUtils.isEmpty(incidencia.getIncidenciaNumero())){
			incidencia.setIncidenciaNumero(
					String.valueOf(
							Integer.parseInt(W83bFactoriaDAO.getIncidenciasDAO().maxIncidencia(incidencia.getIncidenciaAnyo(),incidencia.getIncidenciaTerritorio()))+1
					)
			);
		}

			if ("0".equals(incidencia.getUsuarioBean().getRegManual()))
			{
				
				 String observaciones="Incidencia n: "+incidencia.getIncidenciaTerritorio()+"/"+incidencia.getIncidenciaAnyo()+"/"+incidencia.getIncidenciaNumero();//NOPMD
				 String empresa="";
				 empresa=incidencia.getDniSolicitante();
				if(StringUtils.isEmpty(empresa)){
					empresa = incidencia.getActa().getCodCentro();
				}
					
				try{
					String [] resul=W83bLibroRegistro.getAltaRegistro(true, incidencia.getUsuarioBean().getModelo(), "E", "E", empresa, incidencia.getIncidenciaTerritorio(), "", observaciones, incidencia.getUsuarioBean());
					incidencia.setFecRegistro(resul[1]);
					incidencia.setNumRegistroES(resul[0]);
				}catch (W83bLibroRegistroException e) {
					// TODO: handle exception
				}
				//Fin Libro Registro
			}
			incidencia.setValidada(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		
			incidencia.setListaDiferenciasActa(W83bFactoriaDAO.getIncidenciasDAO().encontrarDiferenciasActa(
					incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
			
			incidencia.setListaDocumentosActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerDocsActas(
					incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
			
			incidencia.setListaEscrutinioActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerEscrutinio(
					incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
			
			incidencia.setListaPapeletasActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerPapeletas(
					incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion()));
			
			incidencia.setListaHistorialTramitacionActa(W83bFactoriaDAO.getIncidenciasDAO().buscarHistorialTramitacionIncidencias(
					incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
			
			/*incidencia.setListaImpugnacionesActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerImpugnaciones(
					incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));*/
			
			
			
			incidencia.getActa().setVersionActa(String.valueOf((Integer.parseInt(W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidadaNoValidadaDescartada(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero()))+1)));
			incidencia.setActaVersion(incidencia.getActa().getVersionActa());
			incidencia.setFase(W83bClsConstantes.FASE_INCIDENCIAS);
			incidencia.setTramite(W83bClsConstantes.TRAMITE_INCIDENCIA_RECEPCION);
			
			
			incidencia.getActa().setIdioma(incidencia.getIdioma());
			incidencia.getActa().setValidada(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
			W83bFactoriaDAO.getIncidenciasDAO().insertarActa(incidencia.getActa());
			
			
			HashMap difDelegados = incidencia.getDifDelegados();
			
	
			
			W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidencia(incidencia);
			W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaAuditoria(incidencia,W83bClsConstantes.CONSTANTE_HISTORIAL_MODO_ESCRITURA);
			for(int i=0,size=incidencia.getListaDelegados().size();i<size;i++){
				W83bDelegadosBean delegado = (W83bDelegadosBean)incidencia.getListaDelegados().get(i);
				W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaTipoSustitucion(incidencia,delegado.getDniSustituido(),delegado.getDniDelegado());
			}
			W83bFactoriaDAO.getIncidenciasDAO().insertarDocsIncidencias(incidencia);
			W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaHistorial(incidencia,incidencia.getFecRegistro());
			
			for (int i=0;i<incidencia.getListaDocs().size();i++){			
				W83bDocBean doc=(W83bDocBean)incidencia.getListaDocs().get(i);
				
				if(!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(doc.getCodTramite())){
					W83bNuevaIncidenciasBean incidenciaNueva = new W83bNuevaIncidenciasBean();//NOPMD
					incidenciaNueva.setIncidenciaTerritorio(incidencia.getIncidenciaTerritorio());
					incidenciaNueva.setIncidenciaAnyo(incidencia.getIncidenciaAnyo());
					incidenciaNueva.setIncidenciaNumero(incidencia.getIncidenciaNumero());
					incidenciaNueva.setTramite(doc.getCodTramite());
					incidenciaNueva.setFase(doc.getCodFase());
					incidenciaNueva.setUsuarioBean(incidencia.getUsuarioBean());
					incidenciaNueva.setIdioma(incidencia.getIdioma());
					
					if(!W83bFactoriaDAO.getIncidenciasDAO().buscarHistorialTramitacion(incidenciaNueva)){
						W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaHistorial(incidenciaNueva,doc.getFechaRegistro());
					}else{
						W83bFactoriaDAO.getIncidenciasDAO().actualizarIncidenciaHistorial(incidenciaNueva,doc.getFechaRegistro());				
					}			
				}
			}
			
			/*for(int i=0,size=incidencia.getListaImpugnacionesActa().size();i<size;i++){
				W83bIncidenciaImpugnacionBean bean = (W83bIncidenciaImpugnacionBean)incidencia.getListaImpugnacionesActa().get(i);
				bean.setIdioma(incidencia.getIdioma());
				bean.setUsuarioBean(incidencia.getUsuarioBean());
				bean.setVersion(incidencia.getActaVersion());
				W83bFactoriaDAO.getIncidenciasDAO().actualizarImpugnacionIncidencia(bean);

			}*/
			for(int i=0,size=incidencia.getListaHistorialTramitacionActa().size();i<size;i++){
				W83bIncidenciaHistorialActaBean bean = (W83bIncidenciaHistorialActaBean)incidencia.getListaHistorialTramitacionActa().get(i);
				bean.setIdioma(incidencia.getIdioma());
				bean.setUsuarioBean(incidencia.getUsuarioBean());
				bean.setVersionActa(incidencia.getActaVersion());

				W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaHistorialTramitacion(bean);
			}
			
			W83bActasBean acta = new W83bActasBean();
			acta.setNumActa(incidencia.getActaNumero());		
			acta.setNumActaAno(incidencia.getActaAnyo());
			acta.setTerritorioActaTotal(incidencia.getActaTerritorio());
			acta.setNumActaTerritorio(incidencia.getActaTerritorio());
			acta.setTramite(incidencia.getTramite());
			acta.setFase(incidencia.getFase());
			acta.setUsuarioBean(incidencia.getUsuarioBean());
			acta.setVersion(incidencia.getActaVersion());
			
			if(!W83bFactoriaDAO.getActasDAO().buscarHistorialTramitacion(acta.getUsuarioBean(), incidencia.getActaVersion(), acta)){
				W83bIncidenciaHistorialActaBean beanHist = new W83bIncidenciaHistorialActaBean();
				beanHist.setNumActa(incidencia.getActaNumero());
				beanHist.setAnyoActa(incidencia.getActaAnyo());
				beanHist.setTerritorioActa(incidencia.getActaTerritorio());
				beanHist.setVersionActa(incidencia.getActaVersion());
				beanHist.setTramitacionActa(incidencia.getTramite());
				beanHist.setFaseActa(incidencia.getFase());
				beanHist.setUsuarioActa(incidencia.getUsuarioBean().getIdUsuario());
				beanHist.setUsuarioBean(incidencia.getUsuarioBean());
				beanHist.setIdioma(incidencia.getIdioma());
				beanHist.setFechaActualizacionActa(W83bDateUtil.getInstance().getPatronStringFromDate(new Date(), W83bDateUtil.getInstance().devolverFormatoHoraIdioma(incidencia.getIdioma())));
//				SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
				W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaHistorialTramitacion(beanHist);
			}else{
//				W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacionFechaModificacion(acta,hoy.format(new Date()));
				W83bFactoriaDAO.getIncidenciasDAO().editarHistorialTramitacion(acta);
			}
			
			int sumaTotalDelegados = 0;
			int sumaTotalDelegadosH = 0;
			int sumaTotalDelegadosM = 0;
			
			for(int i=0,size=incidencia.getListaEscrutinioActa().size();i<size;i++){
				W83bEscrutinioBean bean = (W83bEscrutinioBean)incidencia.getListaEscrutinioActa().get(i);
				bean.setDelegadosHombres(bean.getDelegadosHombres());
				bean.setDelegadosMujeres(bean.getDelegadosMujeres());				

				String hombres = (String)difDelegados.get(bean.getCodSindicato()+"_"+bean.getCodColegio()+"_"+"H");
				String mujeres = (String)difDelegados.get(bean.getCodSindicato()+"_"+bean.getCodColegio()+"_"+"M");
				String hombresAnt = bean.getDelegadosHombres();
				String mujeresAnt = bean.getDelegadosMujeres();
				
				int delegadosRestarDiferenciasHombres = 0;
				int delegadosRestarDiferenciasMujeres = 0;
				
				if(StringUtils.isNotEmpty(hombres)
						||StringUtils.isNotEmpty(mujeres)){
					if(StringUtils.isEmpty(hombres)){
						hombres = "0";
					}
					if(StringUtils.isEmpty(mujeres)){
						mujeres = "0";
					}
					hombres = String.valueOf(Integer.parseInt(hombresAnt)+Integer.parseInt(hombres));//NOPMD
					mujeres = String.valueOf(Integer.parseInt(mujeresAnt)+Integer.parseInt(mujeres));//NOPMD
					if(0>Integer.parseInt(hombres)){
						delegadosRestarDiferenciasHombres = 0+Integer.parseInt(hombres);
						hombres = "0";
					}
					
					if(0>Integer.parseInt(mujeres)){
						delegadosRestarDiferenciasMujeres = 0+Integer.parseInt(mujeres);
						mujeres = "0";
					}
					
				}else{
					hombres = bean.getDelegadosHombres();
					mujeres =  bean.getDelegadosMujeres();
				}
				
				sumaTotalDelegados = sumaTotalDelegados + Integer.parseInt(hombres) + Integer.parseInt(mujeres);
				sumaTotalDelegadosH = sumaTotalDelegadosH + Integer.parseInt(hombres);
				sumaTotalDelegadosM = sumaTotalDelegadosM + Integer.parseInt(mujeres);
				
				bean.setDelegadosHombres(hombres);
				bean.setDelegadosMujeres(mujeres);
				
				bean.setIdioma(incidencia.getIdioma());
				bean.setUsuarioBean(incidencia.getUsuarioBean());
				bean.setActaVersion(incidencia.getActaVersion());
				W83bFactoriaDAO.getIncidenciasDAO().insertarEscrutinio(bean);
				
				bean.setDelegadosHombres(String.valueOf(delegadosRestarDiferenciasHombres));
				bean.setDelegadosMujeres(String.valueOf(delegadosRestarDiferenciasMujeres));	
			}
			for(int i=0,size=incidencia.getListaDiferenciasActa().size();i<size;i++){
				W83bListaDiferenciasBean bean = (W83bListaDiferenciasBean)incidencia.getListaDiferenciasActa().get(i);
				bean.setHombres(bean.getHombres());
				bean.setMujeres(bean.getMujeres());
				
				String hombres = (String)difDelegados.get(bean.getSindicato()+"_"+bean.getCodColegio()+"_"+"H");
				String mujeres = (String)difDelegados.get(bean.getSindicato()+"_"+bean.getCodColegio()+"_"+"M");
				String hombresAnt = bean.getHombres();
				String mujeresAnt = bean.getMujeres();
				if(StringUtils.isNotEmpty(hombres)
						||StringUtils.isNotEmpty(mujeres)){
					if(StringUtils.isEmpty(hombres)){
						hombres = "0";
					}
					if(StringUtils.isEmpty(mujeres)){
						mujeres = "0";
					}
					W83bEscrutinioEqualsBean escrutinioEquals = new W83bEscrutinioEqualsBean();//NOPMD
					escrutinioEquals.setCodSindicato(bean.getSindicato());
					escrutinioEquals.setCodColegio(bean.getCodColegio());
					
					int existeEscrutinio = incidencia.getListaEscrutinioActa().indexOf(escrutinioEquals);
					if(-1==existeEscrutinio){
						hombres = String.valueOf(Integer.parseInt(hombresAnt)+Integer.parseInt(hombres));//NOPMD
						mujeres = String.valueOf(Integer.parseInt(mujeresAnt)+Integer.parseInt(mujeres));//NOPMD
					}else{
						W83bEscrutinioBean escrutinio = (W83bEscrutinioBean)incidencia.getListaEscrutinioActa().get(existeEscrutinio);
						hombres = hombresAnt;
						if(0>Integer.parseInt(escrutinio.getDelegadosHombres())){
							hombres = String.valueOf(Integer.parseInt(hombres)+Integer.parseInt(escrutinio.getDelegadosHombres()));//NOPMD							
						}
						mujeres = mujeresAnt;
						if(0>Integer.parseInt(escrutinio.getDelegadosMujeres())){
							mujeres = String.valueOf(Integer.parseInt(mujeres)+Integer.parseInt(escrutinio.getDelegadosMujeres()));//NOPMD				
						}
					}
				}else{
					hombres = bean.getHombres();
					mujeres =  bean.getMujeres();
				}
				
				bean.setHombres(hombres);
				bean.setMujeres(mujeres);
				
				sumaTotalDelegados = sumaTotalDelegados + Integer.parseInt(hombres) + Integer.parseInt(mujeres);
				sumaTotalDelegadosH = sumaTotalDelegadosH + Integer.parseInt(hombres);
				sumaTotalDelegadosM = sumaTotalDelegadosM + Integer.parseInt(mujeres);
				
				bean.setIdioma(incidencia.getIdioma());
				bean.setUsuarioBean(incidencia.getUsuarioBean());
				bean.setVersionActa(incidencia.getActaVersion());
				
				W83bFactoriaDAO.getIncidenciasDAO().insertarDiferencia(bean);
			}
			incidencia.getActa().setTotalTrabajadores(String.valueOf(sumaTotalDelegados));
			incidencia.getActa().setNTrabHombre(String.valueOf(sumaTotalDelegadosH));
			incidencia.getActa().setNTrabMujer(String.valueOf(sumaTotalDelegadosM));
			W83bFactoriaDAO.getIncidenciasDAO().actualizarActaNDelegadosTotales(incidencia.getActa());
			
			for(int i=0,size=incidencia.getListaDocumentosActa().size();i<size;i++){
				W83bDocBeanIncidencia bean = (W83bDocBeanIncidencia)incidencia.getListaDocumentosActa().get(i);
				bean.setIdioma(incidencia.getIdioma());
				bean.setUsuarioBean(incidencia.getUsuarioBean());
				bean.setVersionActa(incidencia.getActaVersion());
				bean.setId(String.valueOf(Integer.parseInt(W83bFactoriaDAO.getIncidenciasDAO().maxDocsActas())+1));
				W83bFactoriaDAO.getIncidenciasDAO().insertarDocsActas(bean);
			}
			
			for(int i=0,size=incidencia.getListaDelegados().size();i<size;i++){
				W83bDelegadosBean bean = (W83bDelegadosBean)incidencia.getListaDelegados().get(i);
				W83bDelegadosBean beanViejo = new W83bDelegadosBean();//NOPMD
				beanViejo.setActaAnyo(bean.getActaAnyo());
				beanViejo.setActaNum(bean.getActaNum());
				beanViejo.setActaTerritorio(bean.getActaTerritorio());
				beanViejo.setActaVersion(versionVieja);
				beanViejo.setDniDelegado(bean.getDniSustituido());
				beanViejo.setIdioma(incidencia.getIdioma());
				beanViejo.setUsuarioBean(incidencia.getUsuarioBean());
				
				List listaDelegados = W83bFactoriaDAO.getIncidenciasDAO().buscarDelegadoIncidencias(beanViejo);
				
				W83bDelegadosBean beanViejoNuevo = (W83bDelegadosBean)listaDelegados.get(0);
				beanViejoNuevo.setDniSustituto(bean.getDniDelegado());
				beanViejoNuevo.setCodBaja(bean.getCodBaja());
				beanViejoNuevo.setFechaBaja(bean.getFechaBaja());
//				beanViejoNuevo.setFechaBaja(W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.getInstance().devolverFormatoIdioma(incidencia.getIdioma())));

				beanViejoNuevo.setActaVersion(incidencia.getActaVersion());
				beanViejoNuevo.setIdioma(incidencia.getIdioma());
				beanViejoNuevo.setUsuarioBean(incidencia.getUsuarioBean());
				W83bFactoriaDAO.getIncidenciasDAO().insertarDelegado(beanViejoNuevo,true);				
				
					bean.setIdioma(incidencia.getIdioma());
					bean.setUsuarioBean(incidencia.getUsuarioBean());
					bean.setActaVersion(incidencia.getActaVersion());
					bean.setFActu(W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.getInstance().devolverFormatoHoraIdioma(incidencia.getIdioma())));
					bean.setCodBaja(bean.getCodBaja());

					bean.setDniSustituto(bean.getDniDelegado());
					bean.setUsuarioBean(incidencia.getUsuarioBean());

				if(StringUtils.isNotEmpty(bean.getDniDelegado())){
					bean.setDniSustituto("");
					bean.setCodBaja("");
					bean.setFechaBaja("");
					bean.setUsuarioBean(incidencia.getUsuarioBean());
					W83bFactoriaDAO.getIncidenciasDAO().insertarDelegado(bean,true);
				}
			}
						
			for(int i=0,size=incidencia.getListaDelegadosActa().size();i<size;i++){
				W83bDelegadosBean delegado = (W83bDelegadosBean)incidencia.getListaDelegadosActa().get(i);
				W83bDelegadosIncidenciasEqualsBean delegadoEqual = new W83bDelegadosIncidenciasEqualsBean();//NOPMD
				delegadoEqual.setTipo("sustituido");
				
				delegadoEqual.setDniDelegado(delegado.getDniDelegado());
				
				if(!incidencia.getListaDelegados().contains(delegadoEqual)
						||(incidencia.getListaDelegados().contains(delegadoEqual))&&StringUtils.isNotEmpty(delegado.getFechaBaja())){
					delegado.setUsuarioBean(incidencia.getUsuarioBean());
					delegado.setActaVersion(incidencia.getActaVersion());
					W83bFactoriaDAO.getIncidenciasDAO().insertarDelegado(delegado,false);
				}
				
			}
			
			for(int i=0,size=incidencia.getListaPapeletasActa().size();i<size;i++){
				W83bPapeletasBean bean = (W83bPapeletasBean)incidencia.getListaPapeletasActa().get(i);
				bean.setIdioma(incidencia.getIdioma());
				bean.setUsuarioBean(incidencia.getUsuarioBean());
				bean.setVersionActa(incidencia.getActaVersion());
				W83bFactoriaDAO.getIncidenciasDAO().insertarPapeletas(bean);
			}
			
			String fechaRegistro = incidencia.getFecRegistro();
			if ("1".equals(incidencia.getUsuarioBean().getRegManual())){
				fechaRegistro = "1";
			}
			
			return incidencia.getIncidenciaNumero()+"___"+fechaRegistro;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#insertarIncidenciaSubsanacion(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String insertarIncidenciaSubsanacion(W83bNuevaIncidenciasBean incidencia)throws Exception{
		


		if ("0".equals(incidencia.getUsuarioBean().getRegManual())){
			if(!W83bClsConstantes.CONSTANTE_ACTA_PARCIAL.equals(incidencia.getTipologiaIncidencia())){
				 String observaciones="Incidencia n: "+incidencia.getIncidenciaTerritorio()+"/"+incidencia.getIncidenciaAnyo()+"/"+incidencia.getIncidenciaNumero();//NOPMD
				 String empresa="";
				 empresa=incidencia.getDniSolicitante();
				if(StringUtils.isEmpty(empresa)){
					empresa = incidencia.getActaOriginal().getCodCentroTrabajo();
				}
				 String [] resul = null;
				 try{
					 resul=W83bLibroRegistro.getAltaRegistro(true, incidencia.getUsuarioBean().getModelo(), "E", "E", empresa, incidencia.getIncidenciaTerritorio(), "", observaciones, incidencia.getUsuarioBean());
					 incidencia.setFecRegistro(resul[1]);
					 incidencia.setNumRegistroES(resul[0]);
				 }catch (W83bLibroRegistroException e) {
					 
				}
				//Fin Libro Registro
			}else{
				incidencia.setFecRegistro(incidencia.getActaNueva().getFechaRegistroES());
				 incidencia.setNumRegistroES(incidencia.getActaNueva().getNumRegistroES());
			}
		}
		incidencia.setActaVersion(W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidadaNoValidada(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero()));
		String versionNueva = String.valueOf((Integer.parseInt(W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidadaNoValidadaDescartada(incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero()))+1));
		
		incidencia.setValidada(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		
		
		incidencia.setListaDiferenciasActa(W83bFactoriaDAO.getIncidenciasDAO().encontrarDiferenciasActa(
				incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
		
		incidencia.setListaDocumentosActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerDocsActas(
				incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
		
		incidencia.setListaEscrutinioActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerEscrutinio(
				incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
		
		incidencia.setListaPapeletasActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerPapeletas(
				incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion()));
		
		incidencia.setListaHistorialTramitacionActa(W83bFactoriaDAO.getIncidenciasDAO().buscarHistorialTramitacionIncidencias(
				incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
		
		/*incidencia.setListaImpugnacionesActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerImpugnaciones(
				incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));*/
		
		incidencia.setListaDelegadosActa(W83bFactoriaDAO.getIncidenciasDAO().buscarDelegadosIncidencias(
				incidencia));
		
		
		incidencia.getActaNueva().setNueva(W83bFactoriaDAO.getIncidenciasDAO().columnaNuevaT16(incidencia));
		
		incidencia.getActa().setVersionActa(String.valueOf((Integer.parseInt(versionNueva))));
		incidencia.setActaVersion(String.valueOf((Integer.parseInt(versionNueva))));
		incidencia.setFase(W83bClsConstantes.FASE_INCIDENCIAS);
		incidencia.setTramite(W83bClsConstantes.TRAMITE_INCIDENCIA_RECEPCION);
		
		
		incidencia.getActaNueva().setFase(incidencia.getFase());
		incidencia.getActaNueva().setTramite(incidencia.getTramite());
		incidencia.getActaNueva().setVersion(versionNueva);
		incidencia.getActaNueva().setUsuarioBean(incidencia.getUsuarioBean());
		incidencia.getActaNueva().setIdioma(incidencia.getIdioma());
		incidencia.getActaNueva().setValidada(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		incidencia.getActaNueva().setNumRegAnyo(incidencia.getActaOriginal().getNumRegAnyo());		

		incidencia.getActaNueva().setPestanasModificadas("Escrutinio_Diferencia_Delegado_Documento");
		for(int i=0,size=incidencia.getListaDocumentosActa().size();i<size;i++){
			boolean encontrado = false;
			
			for(int j=0,size2=incidencia.getActaNueva().getListaDocsBorrados().size();j<size2;j++){
				if(incidencia.getActaNueva().getListaDocsBorrados().get(j)
						.equals(((W83bDocBeanIncidencia)incidencia.getListaDocumentosActa().get(i)).getId())){
					encontrado = true;
					break;
				}
			}
			if(!encontrado){
				incidencia.getActaNueva().getListaDocs().add(((W83bDocBeanIncidencia)incidencia.getListaDocumentosActa().get(i)).w83bDocBeanIncidenciaToW83bDocBean());
			}
		}

		((W83bIActas)(W83bActas.class.newInstance())).anyadirActas(incidencia.getActaNueva(),"incidencias");
		boolean contieneTramitacionIncidencia = false;
		for(int i=0,size=incidencia.getListaHistorialTramitacionActa().size();i<size;i++){
			W83bIncidenciaHistorialActaBean bean = (W83bIncidenciaHistorialActaBean)incidencia.getListaHistorialTramitacionActa().get(i);
			bean.setIdioma(incidencia.getIdioma());
			bean.setUsuarioBean(incidencia.getUsuarioBean());
			bean.setVersionActa(versionNueva);
			
			if((W83bClsConstantes.FASE_INCIDENCIAS.equals(bean.getFaseActa())&&
					W83bClsConstantes.TRAMITE_INCIDENCIA_RECEPCION.equals(bean.getTramitacionActa()))){
				contieneTramitacionIncidencia = true;			
			}
				W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaHistorialTramitacion(bean);				

		}
		
		if(!contieneTramitacionIncidencia){	
			SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
			W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacion(incidencia.getActaNueva(),hoy.format(new Date()));
		}else{
			W83bFactoriaDAO.getIncidenciasDAO().editarHistorialTramitacion(incidencia.getActaNueva());			
		}
		
		
		if(StringUtils.isEmpty(incidencia.getIncidenciaNumero())){
			incidencia.setIncidenciaNumero(
					String.valueOf(
							Integer.parseInt(W83bFactoriaDAO.getIncidenciasDAO().maxIncidencia(incidencia.getIncidenciaAnyo(),incidencia.getIncidenciaTerritorio()))+1
							)
					);
		}
		
		W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidencia(incidencia);
		W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaAuditoria(incidencia,W83bClsConstantes.CONSTANTE_HISTORIAL_MODO_ESCRITURA);

		W83bFactoriaDAO.getIncidenciasDAO().insertarDocsIncidencias(incidencia);
		W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaHistorial(incidencia,incidencia.getFecRegistro());
		
		for (int i=0;i<incidencia.getListaDocs().size();i++){			
			W83bDocBean doc=(W83bDocBean)incidencia.getListaDocs().get(i);
			if(!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(doc.getCodTramite())){
				W83bNuevaIncidenciasBean incidenciaNueva = new W83bNuevaIncidenciasBean();//NOPMD
				incidenciaNueva.setIncidenciaTerritorio(incidencia.getIncidenciaTerritorio());
				incidenciaNueva.setIncidenciaAnyo(incidencia.getIncidenciaAnyo());
				incidenciaNueva.setIncidenciaNumero(incidencia.getIncidenciaNumero());
				incidenciaNueva.setTramite(doc.getCodTramite());
				incidenciaNueva.setFase(doc.getCodFase());
				incidenciaNueva.setUsuarioBean(incidencia.getUsuarioBean());
				incidenciaNueva.setIdioma(incidencia.getIdioma());
				
				if(!W83bFactoriaDAO.getIncidenciasDAO().buscarHistorialTramitacion(incidenciaNueva)){
					W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaHistorial(incidenciaNueva,doc.getFechaRegistro());
				}else{
					W83bFactoriaDAO.getIncidenciasDAO().actualizarIncidenciaHistorial(incidenciaNueva,doc.getFechaRegistro());				
				}	
			}
		}
		
		compararCamposViejosActasInsertar(incidencia,incidencia.getActaNueva(),incidencia.getActaOriginal());
		String fechaRegistro = incidencia.getFecRegistro();
		if ("1".equals(incidencia.getUsuarioBean().getRegManual())){
			fechaRegistro = "1";
		}
		
		if(W83bClsConstantes.CONSTANTE_ACTA_PARCIAL.equals(incidencia.getTipologiaIncidencia())){
			incidencia.setValidada(W83bClsConstantes.CONSTANTE_VALIDADA);
		    
			String fechaEntrada = incidencia.getFecEntrada();
			
			GregorianCalendar calendario = new GregorianCalendar();;
			
			java.util.Date dateEntrada= W83bDateUtil.getInstance().stringToDateIdioma(fechaEntrada,incidencia.getIdioma());
			calendario.setTimeInMillis(dateEntrada.getTime());
			calendario.set(Calendar.MONTH,calendario.get(Calendar.MONTH)+1);
			
			//incidencia.setFecValidacion(W83bDateUtil.getInstance().getDateTime(calendario.getTime(), W83bDateUtil.getInstance().devolverFormatoIdioma(incidencia.getIdioma())));
			
			actualizarIncidencia(incidencia,true);
		}
		
		return incidencia.getIncidenciaNumero()+"___"+fechaRegistro;
	}
	
	/**
	 * Comparar campos viejos actas insertar.
	 *
	 * @param incidencia the incidencia
	 * @param actaNueva the acta nueva
	 * @param actaOriginal the acta original
	 * @return the string
	 * @throws Exception the exception
	 */
	public String compararCamposViejosActasInsertar(W83bNuevaIncidenciasBean incidencia, W83bActasBean actaNueva, W83bActasBean actaOriginal)throws Exception{
		
		if(!(StringUtils.isEmpty(actaNueva.getCodConvenio())&&StringUtils.isEmpty(actaOriginal.getCodConvenio()))
				&&
				(!actaNueva.getCodConvenio().equals(actaOriginal.getCodConvenio()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.convenio,actaOriginal.getCodConvenio(),actaNueva.getCodConvenio());
		}
		if((!(StringUtils.isEmpty(actaNueva.getTerritorioPreaviso())&&StringUtils.isEmpty(actaOriginal.getTerritorioPreaviso()))
				&&
				!actaNueva.getTerritorioPreaviso().equals(actaOriginal.getTerritorioPreaviso()))
				||
				(!(StringUtils.isEmpty(actaNueva.getAnyoPreaviso())&&StringUtils.isEmpty(actaOriginal.getAnyoPreaviso()))
						&&
						!actaNueva.getAnyoPreaviso().equals(actaOriginal.getAnyoPreaviso()))
				||
				(!(StringUtils.isEmpty(actaNueva.getNumPreaviso())&&StringUtils.isEmpty(actaOriginal.getNumPreaviso()))
						&&
						!actaNueva.getNumPreaviso().equals(actaOriginal.getNumPreaviso()))){
			StringBuffer preavisoAnterior = new StringBuffer(W83bClsConstantes.UNO);
			StringBuffer preavisoNuevo = new StringBuffer(W83bClsConstantes.UNO);
			preavisoAnterior.append(actaOriginal.getTerritorioPreaviso());
			preavisoAnterior.append("/");
			preavisoAnterior.append(actaOriginal.getAnyoPreaviso());
			preavisoAnterior.append("/");
			preavisoAnterior.append(actaOriginal.getNumPreaviso());
			preavisoNuevo.append(actaNueva.getTerritorioPreaviso());
			preavisoNuevo.append("/");
			preavisoNuevo.append(actaNueva.getAnyoPreaviso());
			preavisoNuevo.append("/");
			preavisoNuevo.append(actaNueva.getNumPreaviso());
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.preaviso,preavisoAnterior.toString(),preavisoNuevo.toString());
		}
		if(!(StringUtils.isEmpty(actaNueva.getCentroTrabajo().getCifnif())&&StringUtils.isEmpty(actaOriginal.getCentroTrabajo().getCifnif()))
				&&
				(!actaNueva.getCentroTrabajo().getCifnif().equals(actaOriginal.getCentroTrabajo().getCifnif()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.ctoTrabajo,actaOriginal.getCentroTrabajo().getRazonSocial().toUpperCase(),actaNueva.getRegSocial().toUpperCase());
		}
		if(!(StringUtils.isEmpty(actaNueva.getFechaEntrada())&&StringUtils.isEmpty(actaOriginal.getFechaEntrada()))
				&&
				(!actaNueva.getFechaEntrada().equals(actaOriginal.getFechaEntrada()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.fechaEntrada,actaOriginal.getFechaEntrada(),actaNueva.getFechaEntrada());
		}
		if(!(StringUtils.isEmpty(actaNueva.getFechaEleccion())&&StringUtils.isEmpty(actaOriginal.getFechaEleccion()))
				&&
				(!actaNueva.getFechaEleccion().equals(actaOriginal.getFechaEleccion()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.fechaEleccion,actaOriginal.getFechaEleccion(),actaNueva.getFechaEleccion());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDelegadosTotal())&&StringUtils.isEmpty(actaOriginal.getDelegadosTotal()))
				&&
				(!actaNueva.getDelegadosTotal().equals(actaOriginal.getDelegadosTotal()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.totDelegados,actaOriginal.getDelegadosTotal(),actaNueva.getDelegadosTotal());
		}
		if(!(StringUtils.isEmpty(actaNueva.getElectoresTotal())&&StringUtils.isEmpty(actaOriginal.getElectoresTotal()))
				&&
				(!actaNueva.getElectoresTotal().equals(actaOriginal.getElectoresTotal()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.totElectores,actaOriginal.getElectoresTotal(),actaNueva.getElectoresTotal());
		}
		if(!(StringUtils.isEmpty(actaNueva.getCandidatosHombres())&&StringUtils.isEmpty(actaOriginal.getCandidatosHombres()))
				&&
				(!actaNueva.getCandidatosHombres().equals(actaOriginal.getCandidatosHombres()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.ctosHombres,actaOriginal.getCandidatosHombres(),actaNueva.getCandidatosHombres());
		}
		if(!(StringUtils.isEmpty(actaNueva.getCandidatosMujeres())&&StringUtils.isEmpty(actaOriginal.getCandidatosMujeres()))
				&&
				(!actaNueva.getCandidatosMujeres().equals(actaOriginal.getCandidatosMujeres()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.ctosMujeres,actaOriginal.getCandidatosMujeres(),actaNueva.getCandidatosMujeres());
		}

		if(!(StringUtils.isEmpty(actaNueva.getNumRegistroES())&&StringUtils.isEmpty(actaOriginal.getNumRegistroES()))
				&&
				(!actaNueva.getNumRegistroES().equals(actaOriginal.getNumRegistroES()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.numRegES,actaOriginal.getNumRegistroES(),actaNueva.getNumRegistroES());
		}
		String fechaOriginal = actaOriginal.getFechaRegistroES();
		String fechaNueva = actaNueva.getFechaRegistroES();
		if(StringUtils.isNotEmpty(fechaNueva)
				&&8<fechaNueva.length()){
			fechaNueva = fechaNueva.substring(0,10);
		}
		if(StringUtils.isNotEmpty(fechaOriginal)
				&&8<fechaOriginal.length()){
			fechaOriginal = fechaOriginal.substring(0,10);
		}
		if(!(StringUtils.isEmpty(fechaNueva)&&StringUtils.isEmpty(fechaOriginal))
				&&
				(!fechaNueva.equals(fechaOriginal))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.fechaRegES,fechaOriginal,fechaNueva);
		}
		if(!(StringUtils.isEmpty(actaNueva.getFechaComision())&&StringUtils.isEmpty(actaOriginal.getFechaComision()))
				&&
				(!actaNueva.getFechaComision().equals(actaOriginal.getFechaComision()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.fechaComision,actaOriginal.getFechaComision(),actaNueva.getFechaComision());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDelegadosHombres())&&StringUtils.isEmpty(actaOriginal.getDelegadosHombres()))
				&&
				(!actaNueva.getDelegadosHombres().equals(actaOriginal.getDelegadosHombres()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.delegadosHombres,actaOriginal.getDelegadosHombres(),actaNueva.getDelegadosHombres());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDelegadosMujeres())&&StringUtils.isEmpty(actaOriginal.getDelegadosMujeres()))
				&&!actaNueva.getDelegadosMujeres().equals(actaOriginal.getDelegadosMujeres())){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.delegadosMujeres,actaOriginal.getDelegadosMujeres(),actaNueva.getDelegadosMujeres());
		}
		if(!(StringUtils.isEmpty(actaNueva.getElectoresHombres())&&StringUtils.isEmpty(actaOriginal.getElectoresHombres()))
				&&
				(!actaNueva.getElectoresHombres().equals(actaOriginal.getElectoresHombres()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.electoresHombres,actaOriginal.getElectoresHombres(),actaNueva.getElectoresHombres());
		}
		if(!(StringUtils.isEmpty(actaNueva.getElectoresMujeres())&&StringUtils.isEmpty(actaOriginal.getElectoresMujeres()))
				&&
				(!actaNueva.getElectoresMujeres().equals(actaOriginal.getElectoresMujeres()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.electoresMujeres,actaOriginal.getElectoresMujeres(),actaNueva.getElectoresMujeres());
		}
		if(!(StringUtils.isEmpty(actaNueva.getObservaciones())&&StringUtils.isEmpty(actaOriginal.getObservaciones()))
				&&
				(!actaNueva.getObservaciones().equals(actaOriginal.getObservaciones()))){
			if(StringUtils.isEmpty(actaOriginal.getObservaciones())){
				actaOriginal.setObservaciones("");
			}
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.observaciones,actaOriginal.getObservaciones().toUpperCase(),actaNueva.getObservaciones().toUpperCase());
		}
		if(!(StringUtils.isEmpty(actaNueva.getInspeccionada())&&StringUtils.isEmpty(actaOriginal.getInspeccionada()))
				&&
				(!actaNueva.getInspeccionada().equals(actaOriginal.getInspeccionada()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.inspeccionada,actaOriginal.getInspeccionada(),actaNueva.getInspeccionada());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDelegadosMaximo())&&StringUtils.isEmpty(actaOriginal.getDelegadosMaximo()))
				&&
				(!actaNueva.getDelegadosMaximo().equals(actaOriginal.getDelegadosMaximo()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.maxDelegados,actaOriginal.getDelegadosMaximo(),actaNueva.getDelegadosMaximo());
		}
		if(!(StringUtils.isEmpty(actaNueva.getRemitente())&&StringUtils.isEmpty(actaOriginal.getRemitente()))
				&&
				(!actaNueva.getRemitente().equals(actaOriginal.getRemitente()))){
			String remiteOr = actaOriginal.getRemitente();
			String remite = actaNueva.getRemitente();
			if(StringUtils.isEmpty(remiteOr)){
				remiteOr = "";
			}
			if(StringUtils.isEmpty(remite)){
				remite = "";
			}
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.remitente,remiteOr.toUpperCase(),remite.toUpperCase());
		}
		//Escrutinio C1
		Collection c = actaNueva.getDatosEscrutinio().getListaEscrutiniosC1Borrados().values();
		Iterator itr = c.iterator();
		while(itr.hasNext()){
			StringBuffer escrutinio = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
			
			W83bListaEscrutiniosBean escrutinioBean=(W83bListaEscrutiniosBean)itr.next();
			
			W83bEscrutinioEqualsBean escrutinioEqual = new W83bEscrutinioEqualsBean();//NOPMD
			escrutinioEqual.setCodSindicato(escrutinioBean.getSindicato());
			escrutinioEqual.setCodColegio(escrutinioBean.getCodColegio());
			
			int posEscrutinio = incidencia.getListaEscrutinioActa().indexOf(escrutinioEqual);
			
			if(-1!=posEscrutinio){		
				escrutinio.append(escrutinioBean.getSindicato());
				escrutinio.append("-");
				escrutinio.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(escrutinioBean.getSindicato()));
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getHombres());
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getMujeres());
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getNumVotos());
				
				W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.escrutinioSindicatoTA,escrutinio.toString(),"");
			}
		}
		
		c = actaNueva.getDatosEscrutinio().getListaEscrutiniosC1().values();
		itr = c.iterator();
		while(itr.hasNext()){
			W83bListaEscrutiniosBean escrutinioBean=(W83bListaEscrutiniosBean)itr.next();
			
			if(StringUtils.isNotEmpty(escrutinioBean.getFlag())){
				StringBuffer escrutinio = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
				StringBuffer escrutinioOriginal = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
				W83bEscrutinioEqualsBean escrutinioEqual = new W83bEscrutinioEqualsBean();//NOPMD
				escrutinioEqual.setCodSindicato(escrutinioBean.getSindicato());
				escrutinioEqual.setCodColegio(escrutinioBean.getCodColegio());
				
				int posEscrutinio = incidencia.getListaEscrutinioActa().indexOf(escrutinioEqual);
				
				escrutinio.append(escrutinioBean.getSindicato());
				escrutinio.append("-");
				escrutinio.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(escrutinioBean.getSindicato()));
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getHombres());
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getMujeres());
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getNumVotos());
				if(-1!=posEscrutinio){				
					W83bEscrutinioBean escrutinioOriginalBean = (W83bEscrutinioBean)incidencia.getListaEscrutinioActa().get(posEscrutinio);					
					
					escrutinioOriginal.append(escrutinioOriginalBean.getCodSindicato());
					escrutinioOriginal.append("-");
					escrutinioOriginal.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(escrutinioBean.getSindicato()));
					escrutinioOriginal.append("-");
					escrutinioOriginal.append(escrutinioOriginalBean.getDelegadosHombres());
					escrutinioOriginal.append("-");
					escrutinioOriginal.append(escrutinioOriginalBean.getDelegadosMujeres());
					escrutinioOriginal.append("-");
					escrutinioOriginal.append(escrutinioOriginalBean.getNumVotos());
				}
				
				W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.escrutinioSindicatoTA,escrutinioOriginal.toString(),escrutinio.toString());
				
			}			
		}
		//Fin Escrutinio C1
		//Escrutinio C2
		c = actaNueva.getDatosEscrutinio().getListaEscrutiniosC2Borrados().values();
		itr = c.iterator();
		while(itr.hasNext()){
			StringBuffer escrutinio = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
			W83bListaEscrutiniosBean escrutinioBean=(W83bListaEscrutiniosBean)itr.next();
			W83bEscrutinioEqualsBean escrutinioEqual = new W83bEscrutinioEqualsBean();//NOPMD
			escrutinioEqual.setCodSindicato(escrutinioBean.getSindicato());
			escrutinioEqual.setCodColegio(escrutinioBean.getCodColegio());
			
			int posEscrutinio = incidencia.getListaEscrutinioActa().indexOf(escrutinioEqual);
			
			if(-1!=posEscrutinio){	
				escrutinio.append(escrutinioBean.getSindicato());
				escrutinio.append("-");
				escrutinio.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(escrutinioBean.getSindicato()));
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getHombres());
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getMujeres());
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getNumVotos());
				
				W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.escrutinioSindicatoENC,escrutinio.toString(),"");
			}
		}
		
		c = actaNueva.getDatosEscrutinio().getListaEscrutiniosC2().values();
		itr = c.iterator();
		while(itr.hasNext()){
			W83bListaEscrutiniosBean escrutinioBean=(W83bListaEscrutiniosBean)itr.next();
			
			if(StringUtils.isNotEmpty(escrutinioBean.getFlag())){
				StringBuffer escrutinio = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
				StringBuffer escrutinioOriginal = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
				W83bEscrutinioEqualsBean escrutinioEqual = new W83bEscrutinioEqualsBean();//NOPMD
				escrutinioEqual.setCodSindicato(escrutinioBean.getSindicato());
				escrutinioEqual.setCodColegio(escrutinioBean.getCodColegio());
				
				int posEscrutinio = incidencia.getListaEscrutinioActa().indexOf(escrutinioEqual);
				
				escrutinio.append(escrutinioBean.getSindicato());
				escrutinio.append("-");
				escrutinio.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(escrutinioBean.getSindicato()));
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getHombres());
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getMujeres());
				escrutinio.append("-");
				escrutinio.append(escrutinioBean.getNumVotos());
				if(-1!=posEscrutinio){				
					W83bEscrutinioBean escrutinioOriginalBean = (W83bEscrutinioBean)incidencia.getListaEscrutinioActa().get(posEscrutinio);					
					
					escrutinioOriginal.append(escrutinioOriginalBean.getCodSindicato());
					escrutinioOriginal.append("-");
					escrutinioOriginal.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(escrutinioBean.getSindicato()));
					escrutinioOriginal.append("-");
					escrutinioOriginal.append(escrutinioOriginalBean.getDelegadosHombres());
					escrutinioOriginal.append("-");
					escrutinioOriginal.append(escrutinioOriginalBean.getDelegadosMujeres());
					escrutinioOriginal.append("-");
					escrutinioOriginal.append(escrutinioOriginalBean.getNumVotos());
				}
				
				W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.escrutinioSindicatoENC,escrutinioOriginal.toString(),escrutinio.toString());
				
			}			
		}
		//Fin Escrutinio C2
		//Diferencias C1
		c = actaNueva.getDatosDiferencia().getListaDiferenciasC1Borrados().values();
		itr = c.iterator();
		while(itr.hasNext()){
			StringBuffer diferencia = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
			W83bListaDiferenciasBean diferenciaBean=(W83bListaDiferenciasBean)itr.next();
			
			W83bListaDiferenciasEqualsBean diferenciaEqual = new W83bListaDiferenciasEqualsBean();//NOPMD
			diferenciaEqual.setSindicato(diferenciaBean.getSindicato());
			diferenciaEqual.setCodColegio(diferenciaBean.getCodColegio());
			
			int posDiferencia = incidencia.getListaDiferenciasActa().indexOf(diferenciaEqual);
			
			if(-1!=posDiferencia){			
				diferencia.append(diferenciaBean.getSindicato());
				diferencia.append("-");
				diferencia.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(diferenciaBean.getSindicato()));
				diferencia.append("-");
				diferencia.append(diferenciaBean.getHombres());
				diferencia.append("-");
				diferencia.append(diferenciaBean.getMujeres());
				
				W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.difSindicatoTA,diferencia.toString(),"");
			}
		}
		
		c = actaNueva.getDatosDiferencia().getListaDiferenciasC1().values();
		itr = c.iterator();
		while(itr.hasNext()){
			W83bListaDiferenciasBean diferenciaBean=(W83bListaDiferenciasBean)itr.next();
			
			if(StringUtils.isNotEmpty(diferenciaBean.getFlag())){
				StringBuffer diferencia = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
				StringBuffer diferenciaOriginal = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
				W83bListaDiferenciasEqualsBean diferenciaEqual = new W83bListaDiferenciasEqualsBean();//NOPMD
				diferenciaEqual.setSindicato(diferenciaBean.getSindicato());
				diferenciaEqual.setCodColegio(diferenciaBean.getCodColegio());
				
				int posDiferencia = incidencia.getListaDiferenciasActa().indexOf(diferenciaEqual);
				
				diferencia.append(diferenciaBean.getSindicato());
				diferencia.append("-");
				diferencia.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(diferenciaBean.getSindicato()));
				diferencia.append("-");
				diferencia.append(diferenciaBean.getHombres());
				diferencia.append("-");
				diferencia.append(diferenciaBean.getMujeres());
				if(-1!=posDiferencia){				
					W83bListaDiferenciasBean diferenciaOriginalBean = (W83bListaDiferenciasBean)incidencia.getListaDiferenciasActa().get(posDiferencia);					
					
					diferenciaOriginal.append(diferenciaOriginalBean.getSindicato());
					diferenciaOriginal.append("-");
					diferenciaOriginal.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(diferenciaBean.getSindicato()));
					diferenciaOriginal.append("-");
					diferenciaOriginal.append(diferenciaOriginalBean.getHombres());
					diferenciaOriginal.append("-");
					diferenciaOriginal.append(diferenciaOriginalBean.getMujeres());
				}
				
				W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.difSindicatoTA,diferenciaOriginal.toString(),diferencia.toString());
				
			}			
		}
		//Fin Diferencias C1
		//Diferencias C2
		c = actaNueva.getDatosDiferencia().getListaDiferenciasC2Borrados().values();
		itr = c.iterator();
		while(itr.hasNext()){
			StringBuffer diferencia = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
			W83bListaDiferenciasBean diferenciaBean=(W83bListaDiferenciasBean)itr.next();
			W83bListaDiferenciasEqualsBean diferenciaEqual = new W83bListaDiferenciasEqualsBean();//NOPMD
			diferenciaEqual.setSindicato(diferenciaBean.getSindicato());
			diferenciaEqual.setCodColegio(diferenciaBean.getCodColegio());
			
			int posDiferenica = incidencia.getListaDiferenciasActa().indexOf(diferenciaEqual);
			
			if(-1!=posDiferenica){	
				diferencia.append(diferenciaBean.getSindicato());
				diferencia.append("-");
				diferencia.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(diferenciaBean.getSindicato()));
				diferencia.append("-");
				diferencia.append(diferenciaBean.getHombres());
				diferencia.append("-");
				diferencia.append(diferenciaBean.getMujeres());
				
				W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.difSindicatoENC,diferencia.toString(),"");
			}
		}
		
		c = actaNueva.getDatosDiferencia().getListaDiferenciasC2().values();
		itr = c.iterator();
		while(itr.hasNext()){
			W83bListaDiferenciasBean diferenciaBean=(W83bListaDiferenciasBean)itr.next();
			
			if(StringUtils.isNotEmpty(diferenciaBean.getFlag())){
				StringBuffer diferencia = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
				StringBuffer diferenciaOriginal = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
				W83bListaDiferenciasEqualsBean diferenciaEqual = new W83bListaDiferenciasEqualsBean();//NOPMD
				diferenciaEqual.setSindicato(diferenciaBean.getSindicato());
				diferenciaEqual.setCodColegio(diferenciaBean.getCodColegio());
				
				int posDiferenica = incidencia.getListaDiferenciasActa().indexOf(diferenciaEqual);
				
				diferencia.append(diferenciaBean.getSindicato());
				diferencia.append("-");
				diferencia.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(diferenciaBean.getSindicato()));
				diferencia.append("-");
				diferencia.append(diferenciaBean.getHombres());
				diferencia.append("-");
				diferencia.append(diferenciaBean.getMujeres());
				if(-1!=posDiferenica){				
					W83bListaDiferenciasBean diferenciaOriginalBean = (W83bListaDiferenciasBean)incidencia.getListaDiferenciasActa().get(posDiferenica);					
					
					diferenciaOriginal.append(diferenciaOriginalBean.getSindicato());
					diferenciaOriginal.append("-");
					diferenciaOriginal.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(diferenciaBean.getSindicato()));
					diferenciaOriginal.append("-");
					diferenciaOriginal.append(diferenciaOriginalBean.getHombres());
					diferenciaOriginal.append("-");
					diferenciaOriginal.append(diferenciaOriginalBean.getMujeres());
				}
				
				W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.difSindicatoENC,diferenciaOriginal.toString(),diferencia.toString());
				
			}			
		}
		//Fin Diferencias C2
		if(!(StringUtils.isEmpty(actaNueva.getDatosEscrutinio().getPapeletasBlancasC1())&&StringUtils.isEmpty(actaOriginal.getDatosEscrutinio().getPapeletasBlancasC1()))
				&&
				(!actaNueva.getDatosEscrutinio().getPapeletasBlancasC1().equals(actaOriginal.getDatosEscrutinio().getPapeletasBlancasC1()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.papeletasBlancasTA,actaOriginal.getDatosEscrutinio().getPapeletasBlancasC1(),actaNueva.getDatosEscrutinio().getPapeletasBlancasC1());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDatosEscrutinio().getPapeletasValidasC1())&&StringUtils.isEmpty(actaOriginal.getDatosEscrutinio().getPapeletasValidasC1()))
				&&
				(!actaNueva.getDatosEscrutinio().getPapeletasValidasC1().equals(actaOriginal.getDatosEscrutinio().getPapeletasValidasC1()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.papeletasValidasTA,actaOriginal.getDatosEscrutinio().getPapeletasValidasC1(),actaNueva.getDatosEscrutinio().getPapeletasValidasC1());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDatosEscrutinio().getPapeletasNulasC1())&&StringUtils.isEmpty(actaOriginal.getDatosEscrutinio().getPapeletasNulasC1()))
				&&
				(!actaNueva.getDatosEscrutinio().getPapeletasNulasC1().equals(actaOriginal.getDatosEscrutinio().getPapeletasNulasC1()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.papeletasNulasTA,actaOriginal.getDatosEscrutinio().getPapeletasNulasC1(),actaNueva.getDatosEscrutinio().getPapeletasNulasC1());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDatosEscrutinio().getElectoresTotalColegioC1())&&StringUtils.isEmpty(actaOriginal.getDatosEscrutinio().getElectoresTotalColegioC1()))
				&&
				(!actaNueva.getDatosEscrutinio().getElectoresTotalColegioC1().equals(actaOriginal.getDatosEscrutinio().getElectoresTotalColegioC1()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.electoresTA,actaOriginal.getDatosEscrutinio().getElectoresTotalColegioC1(),actaNueva.getDatosEscrutinio().getElectoresTotalColegioC1());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDatosEscrutinio().getVotantesTotalColegioC1())&&StringUtils.isEmpty(actaOriginal.getDatosEscrutinio().getVotantesTotalColegioC1()))
				&&
				(!actaNueva.getDatosEscrutinio().getVotantesTotalColegioC1().equals(actaOriginal.getDatosEscrutinio().getVotantesTotalColegioC1()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.votantesTA,actaOriginal.getDatosEscrutinio().getVotantesTotalColegioC1(),actaNueva.getDatosEscrutinio().getVotantesTotalColegioC1());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDatosEscrutinio().getPapeletasBlancasC2())&&StringUtils.isEmpty(actaOriginal.getDatosEscrutinio().getPapeletasBlancasC2()))
				&&
				(!actaNueva.getDatosEscrutinio().getPapeletasBlancasC2().equals(actaOriginal.getDatosEscrutinio().getPapeletasBlancasC2()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.papeletasBlancasENC,actaOriginal.getDatosEscrutinio().getPapeletasBlancasC2(),actaNueva.getDatosEscrutinio().getPapeletasBlancasC2());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDatosEscrutinio().getPapeletasValidasC2())&&StringUtils.isEmpty(actaOriginal.getDatosEscrutinio().getPapeletasValidasC2()))
				&&
				(!actaNueva.getDatosEscrutinio().getPapeletasValidasC2().equals(actaOriginal.getDatosEscrutinio().getPapeletasValidasC2()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.papeletasValidasENC,actaOriginal.getDatosEscrutinio().getPapeletasValidasC2(),actaNueva.getDatosEscrutinio().getPapeletasValidasC2());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDatosEscrutinio().getPapeletasNulasC2())&&StringUtils.isEmpty(actaOriginal.getDatosEscrutinio().getPapeletasNulasC2()))
				&&
				(!actaNueva.getDatosEscrutinio().getPapeletasNulasC2().equals(actaOriginal.getDatosEscrutinio().getPapeletasNulasC2()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.papeletasNulasENC,actaOriginal.getDatosEscrutinio().getPapeletasNulasC2(),actaNueva.getDatosEscrutinio().getPapeletasNulasC2());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDatosEscrutinio().getElectoresTotalColegioC2())&&StringUtils.isEmpty(actaOriginal.getDatosEscrutinio().getElectoresTotalColegioC2()))
				&&
				(!actaNueva.getDatosEscrutinio().getElectoresTotalColegioC2().equals(actaOriginal.getDatosEscrutinio().getElectoresTotalColegioC2()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.electoresENC,actaOriginal.getDatosEscrutinio().getElectoresTotalColegioC2(),actaNueva.getDatosEscrutinio().getElectoresTotalColegioC2());
		}
		if(!(StringUtils.isEmpty(actaNueva.getDatosEscrutinio().getVotantesTotalColegioC2())&&StringUtils.isEmpty(actaOriginal.getDatosEscrutinio().getVotantesTotalColegioC2()))
				&&
				(!actaNueva.getDatosEscrutinio().getVotantesTotalColegioC2().equals(actaOriginal.getDatosEscrutinio().getVotantesTotalColegioC2()))){
			W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.votantesENC,actaOriginal.getDatosEscrutinio().getVotantesTotalColegioC2(),actaNueva.getDatosEscrutinio().getVotantesTotalColegioC2());
		}
		
		//DocAdj
		List listaDocuBorrados = actaNueva.getListaDocsBorradosCompleto();
		if(null!=listaDocuBorrados){
			itr = listaDocuBorrados.iterator();
			while(itr.hasNext()){
				StringBuffer docStr = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
				String doc=(String)itr.next();
				docStr.append(doc);
				
				W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.docAdjuntos,docStr.toString(),"");
			}
		}
		
		if(null!=actaNueva.getListaDocs()){
			itr = actaNueva.getListaDocs().iterator();
			while(itr.hasNext()){
				W83bDocBean docBean=(W83bDocBean)itr.next();
				
				if(StringUtils.isNotEmpty(docBean.getFlag())){
					StringBuffer doc = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
					
					doc.append(docBean.getNombre());
					
					W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.docAdjuntos,"",doc.toString());
					
				}			
			}
		}
		//Fin DocAdj
		//Delegados		
		c = actaNueva.getListaDelegados().values();
		itr = c.iterator();
		while(itr.hasNext()){
			W83bListaDelegadosBean delegadoBean=(W83bListaDelegadosBean)itr.next();
			
			if(StringUtils.isNotEmpty(delegadoBean.getFlag())){
				if(!W83bClsConstantes.MODO_ALTA.equals((delegadoBean.getFlag()))
						&&StringUtils.isEmpty(delegadoBean.getFechaBaja())){
					StringBuffer delegado = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
					StringBuffer delegadoOriginal = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
					W83bDelegadosEqualsBean delegadoEqual = new W83bDelegadosEqualsBean();//NOPMD
					delegadoEqual.setDniDelegado(delegadoBean.getDni());
					W83bDelegadosEqualsBean delegadoAnterior = new W83bDelegadosEqualsBean();//NOPMD
					delegadoAnterior.setDniDelegado(delegadoBean.getDniEditar());
					int posDiferenica = incidencia.getListaDelegadosActa().indexOf(delegadoEqual);
					boolean dniCambiado=false;
					if(-1==posDiferenica){//ha cambiado el dni, con lo que buscamos el delegado anterior
						dniCambiado=true;
						posDiferenica = incidencia.getListaDelegadosActa().indexOf(delegadoAnterior);
					}
					String colegio = "";
					if("0".equals(delegadoBean.getCodColegio())){
						colegio = "T";
					}else{
						colegio = "E";						
					}
					
					delegado.append(colegio);
					delegado.append("-");
					delegado.append(delegadoBean.getDni());
					delegado.append("-");
					delegado.append(delegadoBean.getNombre());
					delegado.append("-");
					delegado.append(delegadoBean.getApellido1());
					delegado.append("-");
					delegado.append(delegadoBean.getApellido2());
					delegado.append("-");
					delegado.append(delegadoBean.getSexo());
					delegado.append("-");
					delegado.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(delegadoBean.getCodSindicato()));
					if(StringUtils.isNotEmpty(delegadoBean.getFechaBaja())){
						delegado.append("-");
						delegado.append(delegadoBean.getFechaBaja());					
					}
					if(StringUtils.isNotEmpty(delegadoBean.getCodBaja())){
						delegado.append("-");
						delegado.append(delegadoBean.getCodBaja());					
					}
					if(StringUtils.isNotEmpty(delegadoBean.getDniSustituto())){
						delegado.append("-");
						delegado.append(delegadoBean.getDniSustituto());					
					}
					delegado.append("-");
					delegado.append(delegadoBean.getFechaAlta());	
					//if(-1!=posDiferenica){				
						W83bDelegadosBean delegadoOriginalBean = (W83bDelegadosBean)incidencia.getListaDelegadosActa().get(posDiferenica);					
						String colegioOriginal = "";
						if("0".equals(delegadoOriginalBean.getCodColegio())){
							colegioOriginal = "T";
						}else{
							colegioOriginal = "E";						
						}
						delegadoOriginal.append(colegioOriginal);
						delegadoOriginal.append("-");
						if(!dniCambiado){//si no ha cambiado el dni
							delegadoOriginal.append(delegadoOriginalBean.getDniDelegado());
						}else{//si si que ha cambiado el dni
							delegadoOriginal.append(delegadoBean.getDniEditar());
						}
						delegadoOriginal.append("-");
						delegadoOriginal.append(delegadoOriginalBean.getNombreDelegado());
						delegadoOriginal.append("-");
						delegadoOriginal.append(delegadoOriginalBean.getPrimerApellidoDelegado());
						delegadoOriginal.append("-");
						delegadoOriginal.append(delegadoOriginalBean.getSegundoApellidoDelegado());
						delegadoOriginal.append("-");
						delegadoOriginal.append(delegadoOriginalBean.getSexoDelegado());
						delegadoOriginal.append("-");
						delegadoOriginal.append(W83bFactoriaDAO.getComunesDAO().buscarSiglasSindicato(delegadoOriginalBean.getCodSindicato()));
						delegadoOriginal.append("-");
						delegadoOriginal.append(delegadoOriginalBean.getFechaAlta());
					//}
					
					W83bFactoriaDAO.getIncidenciasDAO().insertarCamposModifSubsanaciones(incidencia,W83bClsConstantes.delegado,delegadoOriginal.toString().toUpperCase(),delegado.toString().toUpperCase());
				}else if(W83bClsConstantes.MODO_ALTA.equals((delegadoBean.getFlag()))){
						
						W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaTipoSustitucion(incidencia,delegadoBean.getDniSustituto(),delegadoBean.getDni());
						
						
				}else {
						Collection c2 = actaNueva.getListaDelegados().values();
						Iterator itr2 = c2.iterator();
						String dniSustituto = "";
						if(StringUtils.isNotEmpty(delegadoBean.getDniSustituto())){
							while(itr2.hasNext()){
								W83bListaDelegadosBean delegadoBean2=(W83bListaDelegadosBean)itr2.next();//NOPMD
								if(delegadoBean.getDniSustituto().equals(delegadoBean2.getDni())){
									dniSustituto = delegadoBean2.getDni();

									break;
								}							
							}	
						}

							W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaTipoSustitucion(incidencia,delegadoBean.getDni(),dniSustituto);
							W83bDelegadosBean bean = new W83bDelegadosBean();//NOPMD
							bean.setDniSustituto(dniSustituto);
							bean.setCodBaja(delegadoBean.getCodBaja());
							bean.setActaTerritorio(incidencia.getActaTerritorio());
							bean.setActaAnyo(incidencia.getActaAnyo());
							bean.setActaNum(incidencia.getActaNumero());
							bean.setDniSustituido(delegadoBean.getDni());
							bean.setUsuarioBean(incidencia.getUsuarioBean());
							
				}
			}			
		}
		//Fin Delegados		
		
		
		return "";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#detalleIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public W83bNuevaIncidenciasBean detalleIncidencia(W83bNuevaIncidenciasBean incidencia)throws Exception{
//		INSERTA LNEA DE CONSULTA DE LA INCIDENCIA EN LA TABLA DE HISTORIAL
		W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaAuditoria(incidencia,W83bClsConstantes.CONSTANTE_HISTORIAL_MODO_LECTURA);
//		FIN INSERTA LNEA DE CONSULTA DE LA INCIDENCIA EN LA TABLA DE HISTORIAL
		
		W83bNuevaIncidenciasBean nuevaIncidencias = (W83bNuevaIncidenciasBean)W83bFactoriaDAO.getIncidenciasDAO().detalleIncidencias(incidencia).get(0);
		
		if(W83bClsConstantes.CONSTANTE_SUBSANACION.equals(nuevaIncidencias.getTipologiaIncidencia())||
				W83bClsConstantes.CONSTANTE_ACTA_PARCIAL.equals(nuevaIncidencias.getTipologiaIncidencia())){
			nuevaIncidencias.setIdioma(incidencia.getIdioma());
			nuevaIncidencias.setListaCambiosSubnacion(W83bFactoriaDAO.getIncidenciasDAO().obtenerCambiosSubsanacionIncidencias(nuevaIncidencias));
		}
		
		List delegadosSustitucion = W83bFactoriaDAO.getIncidenciasDAO().obtenerDelegadosSustitucion(nuevaIncidencias);
		
		List delegadosTabla = new ArrayList();
		
		for(int i=0,size = delegadosSustitucion.size();i<size;i++){
			HashMap mapaDelegado = (HashMap)delegadosSustitucion.get(i);
			W83bDelegadosBean beanViejo = new W83bDelegadosBean();//NOPMD
			beanViejo.setActaAnyo(nuevaIncidencias.getActaAnyo());
			beanViejo.setActaNum(nuevaIncidencias.getActaNumero());
			beanViejo.setActaTerritorio(nuevaIncidencias.getActaTerritorio());
			beanViejo.setActaVersion(nuevaIncidencias.getActaVersion());
			beanViejo.setUsuarioBean(incidencia.getUsuarioBean());
	
			beanViejo.setDniDelegado((String)mapaDelegado.get(W83bIncidenciasTipoSustitucionBD.DNI_SUSTITUTO_067));				
			beanViejo.setIdioma(incidencia.getIdioma());
		
			W83bDelegadosEqualsBean delegadoEqual = new W83bDelegadosEqualsBean();//NOPMD
			delegadoEqual.setDniDelegado(beanViejo.getDniDelegado());
			
			int posDiferenica = -1;
			
			if(StringUtils.isNotEmpty(beanViejo.getDniDelegado())){
				posDiferenica = delegadosTabla.indexOf(delegadoEqual);
			}
			if(posDiferenica==-1){					
				List listaDelegados = new ArrayList();//NOPMD
					
				if(StringUtils.isNotEmpty(beanViejo.getDniDelegado())){
					listaDelegados = W83bFactoriaDAO.getIncidenciasDAO().buscarDetalleDelegadoIncidencias(beanViejo,false);
				}
				
				if(0<listaDelegados.size()){

						delegadosTabla.addAll(listaDelegados);
					}
					beanViejo.setDniDelegado((String)mapaDelegado.get(W83bIncidenciasTipoSustitucionBD.DNI_SUTITUIDO_067));
					listaDelegados = W83bFactoriaDAO.getIncidenciasDAO().buscarDetalleDelegadoIncidencias(beanViejo,false);
					
					if(0<listaDelegados.size()){

						delegadosTabla.addAll(listaDelegados);
					}
				}
		}
		
		W83bDelegadosBean beanViejo = new W83bDelegadosBean();//NOPMD
		beanViejo.setActaAnyo(nuevaIncidencias.getActaAnyo());
		beanViejo.setActaNum(nuevaIncidencias.getActaNumero());
		beanViejo.setActaTerritorio(nuevaIncidencias.getActaTerritorio());
		beanViejo.setActaVersion(nuevaIncidencias.getActaVersion());
		beanViejo.setIdioma(incidencia.getIdioma());
		beanViejo.setUsuarioBean(incidencia.getUsuarioBean());
		
		nuevaIncidencias.setListaDelegados(delegadosTabla);
		
		nuevaIncidencias.setListaDocs(W83bFactoriaDAO.getIncidenciasDAO().obtenerDocumentosIncidencia(incidencia));
		
		nuevaIncidencias.setListaAuditoriaIncidencias(W83bFactoriaDAO.getIncidenciasDAO().obtenerRegistrosAuditoria(incidencia));
		
		nuevaIncidencias.setListaHistorialIncidencias(W83bFactoriaDAO.getIncidenciasDAO().obtenerRegistrosTramitacion(incidencia));
		
		
		return nuevaIncidencias;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#actualizarIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String actualizarIncidencia(W83bNuevaIncidenciasBean incidencia,boolean actaParcial)throws Exception{
		
		String errorLibroRegistro = "";
		W83bFactoriaDAO.getIncidenciasDAO().actualizarIncidencia(incidencia);
		if(!actaParcial){
			W83bFactoriaDAO.getIncidenciasDAO().borrarDocsIncidencias(incidencia);
			String error = W83bFactoriaDAO.getIncidenciasDAO().insertarDocsIncidencias(incidencia);
			if("true".equals(error)){
				errorLibroRegistro = "-3";
			}
			//INSERTA LNEA DE CONSULTA DE LA INCIDENCIA EN LA TABLA DE HISTORIAL
			W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaAuditoria(incidencia,W83bClsConstantes.CONSTANTE_HISTORIAL_MODO_ACTUALIZACION);
		}

		
		if(W83bClsConstantes.CONSTANTE_VALIDADA.equals(incidencia.getValidada())){
			//Incidencia validada
			
			incidencia.setTramite(W83bClsConstantes.TRAMITE_INCIDENCIA_MODIFICACION_ACTA);
			incidencia.setFase(W83bClsConstantes.FASE_INCIDENCIAS);
			
			//metemos la fecha de hoy en el tramite
			W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaHistorial(incidencia,"");
			W83bFactoriaDAO.getIncidenciasDAO().actualizarActaValidada(incidencia);
		
			W83bActasBean acta = new W83bActasBean();		
			acta.setNumActa(incidencia.getActaNumero());
			acta.setNumActaAno(incidencia.getActaAnyo());
			acta.setNumActaTerritorio(incidencia.getActaTerritorio());
			acta.setTerritorioActaTotal(incidencia.getActaTerritorio());
			acta.setVersion(incidencia.getActaVersion());
			acta.setTramite(incidencia.getTramite());
			acta.setFase(incidencia.getFase());
			acta.setUsuarioBean(incidencia.getUsuarioBean());
			acta.setIdioma(incidencia.getIdioma());
			SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
			if(!W83bFactoriaDAO.getActasDAO().buscarHistorialTramitacion(acta.getUsuarioBean(), acta.getVersion(), acta)){
				W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacion(acta,hoy.format(new Date()));
			}else{
				W83bFactoriaDAO.getIncidenciasDAO().editarHistorialTramitacion(acta);
			}
			
			incidencia.setListaImpugnacionesActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerImpugnaciones(
			incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
	
			for(int i=0,size=incidencia.getListaImpugnacionesActa().size();i<size;i++){
				W83bIncidenciaImpugnacionBean bean = (W83bIncidenciaImpugnacionBean)incidencia.getListaImpugnacionesActa().get(i);
				bean.setIdioma(incidencia.getIdioma());
				bean.setUsuarioBean(incidencia.getUsuarioBean());
				bean.setVersion(incidencia.getActaVersion());
				W83bFactoriaDAO.getIncidenciasDAO().actualizarImpugnacionIncidencia(bean);
			}
			
			/*****INICIO ALTAS/BAJAS EN DELEGADOS DE PREVENCIN******/
			//la empresa debe ser menos de 30 empleados (un delegado) para actualizar los delegados de prevencin
			if(W83bFactoriaDAO.getActasDAO().esActaMenorTreintaElectores(acta.getNumActaAno(), acta.getNumActaTerritorio(), acta.getNumActa(), acta.getVersion())){
				//La incidencia tiene que llevar una baja de delegado: buscamos delegados sustituidos y sustitos
				List delegadosSustitucion = W83bFactoriaDAO.getIncidenciasDAO().obtenerDelegadosSustitucion(incidencia);
				if(delegadosSustitucion!=null && !delegadosSustitucion.isEmpty()){
					String dnisDelegadoSustituido=null;
					String dnisDelegadoSustituto=null;
					for(int i=0,size = delegadosSustitucion.size();i<size;i++){
						HashMap mapaDelegado = (HashMap)delegadosSustitucion.get(i);
						if(mapaDelegado.get(W83bIncidenciasTipoSustitucionBD.DNI_SUTITUIDO_067)!=null &&
							!((String)mapaDelegado.get(W83bIncidenciasTipoSustitucionBD.DNI_SUTITUIDO_067)).equals("")){
								dnisDelegadoSustituido = (String)mapaDelegado.get(W83bIncidenciasTipoSustitucionBD.DNI_SUTITUIDO_067);	
						}
						if(mapaDelegado.get(W83bIncidenciasTipoSustitucionBD.DNI_SUSTITUTO_067)!=null &&
								!((String)mapaDelegado.get(W83bIncidenciasTipoSustitucionBD.DNI_SUSTITUTO_067)).equals("")){
							dnisDelegadoSustituto = (String)mapaDelegado.get(W83bIncidenciasTipoSustitucionBD.DNI_SUSTITUTO_067);	
						}
					}
					//Comprobar si el delegado que se da de baja es delegado de prevencion
					if(W83bFactoriaDAO.getDelegadosPrevencionDAO().obtenerDelegadoPrevencionActa(acta, dnisDelegadoSustituido)!=null){
						W83bDelegadosBean delegadoSustituido = W83bFactoriaDAO.getDelegadosDAO().obtenerDelegadoActa(acta, dnisDelegadoSustituido);
						
						//Dar de baja el delegado de prevencin
						W83bFactoriaDAO.getDelegadosPrevencionDAO().updateBajaDelegadoPrevencion(acta, dnisDelegadoSustituido, delegadoSustituido.getFechaBaja());
						
						//Comprobamos si la incidencia tambin lleva un alta
						if(dnisDelegadoSustituto!=null){
							W83bDelegadosBean delegadoSustituto = W83bFactoriaDAO.getDelegadosDAO().obtenerDelegadoActa(acta, dnisDelegadoSustituto);
							delegadoSustituto.setUsuarioBean(incidencia.getUsuarioBean());
							delegadoSustituto.setIdioma(incidencia.getIdioma());
							//Realizar el alta del delegado de prevencin
							W83bFactoriaDAO.getDelegadosPrevencionDAO().insertDelegadoPrevencion(delegadoSustituto);
						}
					}

				}
			}
			/*****FIN ALTAS/BAJAS EN DELEGADOS DE PREVENCIN******/
			
		}else if(W83bClsConstantes.CONSTANTE_DESCARTADA.equals(incidencia.getValidada())){
			//Incidencia validada
			W83bFactoriaDAO.getIncidenciasDAO().actualizarActaValidada(incidencia);
		}
		
		for (int i=0;i<incidencia.getListaDocs().size();i++){			
			W83bDocBean doc=(W83bDocBean)incidencia.getListaDocs().get(i);
			
			if(!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(doc.getCodTramite())){
				W83bNuevaIncidenciasBean incidenciaNueva = new W83bNuevaIncidenciasBean();//NOPMD
				incidenciaNueva.setIncidenciaTerritorio(incidencia.getIncidenciaTerritorio());
				incidenciaNueva.setIncidenciaAnyo(incidencia.getIncidenciaAnyo());
				incidenciaNueva.setIncidenciaNumero(incidencia.getIncidenciaNumero());
				incidenciaNueva.setTramite(doc.getCodTramite());
				incidenciaNueva.setFase(doc.getCodFase());
				incidenciaNueva.setUsuarioBean(incidencia.getUsuarioBean());
				incidenciaNueva.setIdioma(incidencia.getIdioma());
				
				if(!W83bFactoriaDAO.getIncidenciasDAO().buscarHistorialTramitacion(incidenciaNueva)){
					W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaHistorial(incidenciaNueva,doc.getFechaRegistro());
				}else{
					W83bFactoriaDAO.getIncidenciasDAO().actualizarIncidenciaHistorial(incidenciaNueva,doc.getFechaRegistro());				
				}	
			}
		}
		
		return errorLibroRegistro;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#actualizarIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String actualizarIncidenciaSimple(W83bNuevaIncidenciasBean incidencia)throws Exception{
		
		W83bFactoriaDAO.getIncidenciasDAO().actualizarIncidenciaSimple(incidencia);
//		INSERTA LNEA DE CONSULTA DE LA INCIDENCIA EN LA TABLA DE HISTORIAL
		W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaAuditoria(incidencia,W83bClsConstantes.CONSTANTE_HISTORIAL_MODO_ACTUALIZACION);
//		FIN INSERTA LNEA DE CONSULTA DE LA INCIDENCIA EN LA TABLA DE HISTORIAL
		if(W83bClsConstantes.CONSTANTE_VALIDADA.equals(incidencia.getValidada())){
			incidencia.setTramite(W83bClsConstantes.TRAMITE_INCIDENCIA_MODIFICACION_ACTA);
			incidencia.setFase(W83bClsConstantes.FASE_INCIDENCIAS);
			
			//metemos la fecha de hoy en el tramite
			W83bFactoriaDAO.getIncidenciasDAO().anyadirIncidenciaHistorial(incidencia,"");
			
			HashMap mapaActa = W83bFactoriaDAO.getIncidenciasDAO().buscarNumActaIncidencia(incidencia);
			
			
			incidencia.setActaNumero(mapaActa.get(W83bIncidenciasBD.N_ACTA_061).toString());
			incidencia.setActaAnyo(mapaActa.get(W83bIncidenciasBD.ANO_ACTA_061).toString());
			incidencia.setActaTerritorio(mapaActa.get(W83bIncidenciasBD.C_TERRIT_061).toString());
			incidencia.setActaVersion(mapaActa.get(W83bIncidenciasBD.VERSION_ACTA_061).toString());
			
			W83bFactoriaDAO.getIncidenciasDAO().actualizarActaValidada(incidencia);
			
			W83bActasBean acta = new W83bActasBean();		
			acta.setNumActa(incidencia.getActaNumero());
			acta.setNumActaAno(incidencia.getActaAnyo());
			acta.setNumActaTerritorio(incidencia.getActaTerritorio());
			acta.setTerritorioActaTotal(incidencia.getActaTerritorio());
			acta.setVersion(incidencia.getActaVersion());
			acta.setTramite(incidencia.getTramite());
			acta.setFase(incidencia.getFase());
			acta.setUsuarioBean(incidencia.getUsuarioBean());
			SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
//			W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacion(acta,hoy.format(new Date()));
			if(!W83bFactoriaDAO.getActasDAO().buscarHistorialTramitacion(acta.getUsuarioBean(), acta.getVersion(), acta)){
				W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacion(acta,hoy.format(new Date()));
			}else{
//				W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacionFechaModificacion(acta,hoy.format(new Date()));
				W83bFactoriaDAO.getIncidenciasDAO().editarHistorialTramitacion(acta);
			}
			incidencia.setListaImpugnacionesActa(W83bFactoriaDAO.getIncidenciasDAO().obtenerImpugnaciones(
					incidencia.getActaTerritorio(),incidencia.getActaAnyo(),incidencia.getActaNumero(),incidencia.getActaVersion(),incidencia.getIdioma()));
			
					for(int i=0,size=incidencia.getListaImpugnacionesActa().size();i<size;i++){
						W83bIncidenciaImpugnacionBean bean = (W83bIncidenciaImpugnacionBean)incidencia.getListaImpugnacionesActa().get(i);
						bean.setIdioma(incidencia.getIdioma());
						bean.setUsuarioBean(incidencia.getUsuarioBean());
						bean.setVersion(incidencia.getActaVersion());
						W83bFactoriaDAO.getIncidenciasDAO().actualizarImpugnacionIncidencia(bean);
			
					}
		}else if(W83bClsConstantes.CONSTANTE_DESCARTADA.equals(incidencia.getValidada())){
			
			W83bFactoriaDAO.getIncidenciasDAO().actualizarActaValidada(incidencia);
			
		}
		
		return "";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#descargarDocumentoIncidencias(java.lang.String)
	 */
	public w83b.w83bBeans.W83bDocBean descargarDocumentoIncidencias(String idDocumento)throws Exception{
		return W83bFactoriaDAO.getIncidenciasDAO().descargarDocumento(idDocumento);
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#borradoFisicoIncidencias(java.util.ArrayList)
	 */
	public String borradoFisicoIncidencias(ArrayList listIncidencia)throws Exception{
		try{
			W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)listIncidencia.get(listIncidencia.size()-1);
			listIncidencia.remove(listIncidencia.size()-1);
			
			for(int i = 0,size=listIncidencia.size();i<size;i++){
				W83bIncidenciasBean incidencia = (W83bIncidenciasBean)listIncidencia.get(i);//NOPMD
				
				W83bFactoriaDAO.getIncidenciasDAO().borrarSubsanacion(incidencia.getTerritorioIncidencia(),
						  incidencia.getAnyoIncidencia(),
						  incidencia.getNumIncidencia(),
						  userBean);
				W83bFactoriaDAO.getIncidenciasDAO().borrarTablaTipoSustitucion(incidencia.getTerritorioIncidencia(),
						incidencia.getAnyoIncidencia(),
						incidencia.getNumIncidencia(),
						userBean);
				W83bFactoriaDAO.getIncidenciasDAO().borrarTablaHistorialIncidencia(incidencia.getTerritorioIncidencia(),
						incidencia.getAnyoIncidencia(),
						incidencia.getNumIncidencia(),
						userBean);
				W83bFactoriaDAO.getIncidenciasDAO().borrarTablaAuditoriaIncidencia(incidencia.getTerritorioIncidencia(),
						incidencia.getAnyoIncidencia(),
						incidencia.getNumIncidencia(),
						userBean);
				W83bFactoriaDAO.getIncidenciasDAO().borrarTablaDocIncidencia(incidencia.getTerritorioIncidencia(),
						incidencia.getAnyoIncidencia(),
						incidencia.getNumIncidencia(),
						userBean);
				W83bFactoriaDAO.getIncidenciasDAO().borrarTablaIncidencia(incidencia.getTerritorioIncidencia(),
						incidencia.getAnyoIncidencia(),
						incidencia.getNumIncidencia(),
						userBean);
				
				List paramEntrada = new ArrayList();//NOPMD
				paramEntrada.add(
						new StringBuffer(W83bClsConstantes.UNO)//NOPMD
						.append("pos")
						.append("_")
						.append(incidencia.getTerritorioActa())
						.append("_")
						.append(incidencia.getAnyoActa())
						.append("_")
						.append(incidencia.getNumActaSencillo()).toString());
				paramEntrada.add(incidencia.getVersionActa());
				paramEntrada.add(userBean);
				
				((W83bIActas)(W83bActas.class.newInstance())).borrarActasSinIncidencias(paramEntrada);
				
	//			W83bFactoriaDAO.getIncidenciasDAO().actualizarDelegadosActaVersionAnterior(incidencia.getTerritorioActa(),
	//					incidencia.getAnyoActa(),
	//					incidencia.getNumActaSencillo(),
	//					String.valueOf(Integer.parseInt(incidencia.getVersionActa())-1),
	//					userBean);
				
			}
			
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "ErrorborrarActasSinIncidencias",null);
			throw e;
		}
			
			return "0";
		}
		
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#borradoFisicoIncidencias(java.util.ArrayList)
	 */
	public String borradoFisicoIncidenciasSoloIncidencias(ArrayList listIncidencia)throws Exception{
		
		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)listIncidencia.get(listIncidencia.size()-1);
		listIncidencia.remove(listIncidencia.size()-1);
		
		for(int i = 0,size=listIncidencia.size();i<size;i++){
			W83bIncidenciasBean incidencia = (W83bIncidenciasBean)listIncidencia.get(i);//NOPMD
			
			W83bFactoriaDAO.getIncidenciasDAO().borrarSubsanacion(incidencia.getTerritorioIncidencia(),
					incidencia.getAnyoIncidencia(),
					incidencia.getNumIncidencia(),
					userBean);
			W83bFactoriaDAO.getIncidenciasDAO().borrarTablaTipoSustitucion(incidencia.getTerritorioIncidencia(),
					incidencia.getAnyoIncidencia(),
					incidencia.getNumIncidencia(),
					userBean);
			W83bFactoriaDAO.getIncidenciasDAO().borrarTablaHistorialIncidencia(incidencia.getTerritorioIncidencia(),
					incidencia.getAnyoIncidencia(),
					incidencia.getNumIncidencia(),
					userBean);
			W83bFactoriaDAO.getIncidenciasDAO().borrarTablaAuditoriaIncidencia(incidencia.getTerritorioIncidencia(),
					incidencia.getAnyoIncidencia(),
					incidencia.getNumIncidencia(),
					userBean);
			W83bFactoriaDAO.getIncidenciasDAO().borrarTablaDocIncidencia(incidencia.getTerritorioIncidencia(),
					incidencia.getAnyoIncidencia(),
					incidencia.getNumIncidencia(),
					userBean);
			W83bFactoriaDAO.getIncidenciasDAO().borrarTablaIncidencia(incidencia.getTerritorioIncidencia(),
					incidencia.getAnyoIncidencia(),
					incidencia.getNumIncidencia(),
					userBean);
			
			List paramEntrada = new ArrayList();//NOPMD
			paramEntrada.add(
					new StringBuffer(W83bClsConstantes.UNO)//NOPMD
					.append("pos")
					.append("_")
					.append(incidencia.getTerritorioActa())
					.append("_")
					.append(incidencia.getAnyoActa())
					.append("_")
					.append(incidencia.getNumActaSencillo()).toString());
			paramEntrada.add(incidencia.getVersionActa());
			paramEntrada.add(userBean);
			
//			((W83bIActas)(W83bActas.class.newInstance())).borrarActas(paramEntrada);
			
//			W83bFactoriaDAO.getIncidenciasDAO().actualizarDelegadosActaVersionAnterior(incidencia.getTerritorioActa(),
//					incidencia.getAnyoActa(),
//					incidencia.getNumActaSencillo(),
//					String.valueOf(Integer.parseInt(incidencia.getVersionActa())-1),
//					userBean);
			
			
		}
		
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#borradoFisicoIncidencias(java.util.ArrayList)
	 */
	public String validarBorradoFisicoIncidencias(ArrayList listIncidencia)throws Exception{
		
//		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)listIncidencia.get(listIncidencia.size()-1);
		listIncidencia.remove(listIncidencia.size()-1);
		
		for(int i = 0,size=listIncidencia.size();i<size;i++){
			W83bIncidenciasBean incidencia = (W83bIncidenciasBean)listIncidencia.get(i);//NOPMD
			
			if(W83bFactoriaDAO.getIncidenciasDAO().existeIncidenciaPosteriorNoValidada(incidencia)){
				return "-1";				
			}			
		}
		
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIIncidencias#borradoFisicoIncidencias(java.util.ArrayList)
	 */
	public String validarFechaIncidencias(ArrayList listIncidencia)throws Exception{
		
		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)listIncidencia.get(listIncidencia.size()-1);
		listIncidencia.remove(listIncidencia.size()-1);
		String result="0";
		HashMap mapaIncidencias = new HashMap();
		
		for(int i = 0,size=listIncidencia.size();i<size;i++){
				W83bIncidenciasBean incidencia = (W83bIncidenciasBean)listIncidencia.get(i);//NOPMD
				W83bNuevaIncidenciasBean incidenciasNueva = new W83bNuevaIncidenciasBean();//NOPMD
				incidencia.setUsuarioBean(userBean);
				
				incidenciasNueva.setUsuarioBean(userBean);
				incidenciasNueva.setIncidenciaAnyo(incidencia.getAnyoIncidencia());
				incidenciasNueva.setIncidenciaNumero(incidencia.getNumIncidencia());
				incidenciasNueva.setIncidenciaTerritorio(incidencia.getTerritorioIncidencia());
				incidenciasNueva.setFecValidacion(incidencia.getFechaValidacion());
				incidenciasNueva.setIdioma(incidencia.getIdioma());
				incidenciasNueva.setValidada(W83bClsConstantes.CONSTANTE_VALIDADA);
				incidenciasNueva.setActaTerritorio(incidencia.getTerritorioActa());
				incidenciasNueva.setActaAnyo(incidencia.getAnyoActa());
				incidenciasNueva.setActaNumero(incidencia.getNumActaSencillo());
				
				String version = W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidada(incidenciasNueva.getActaTerritorio(),incidenciasNueva.getActaAnyo(),incidenciasNueva.getActaNumero());
				incidenciasNueva.setActaVersion(version);
				
				//incidenciasNueva.setActaVersion(incidencia.getVersionActa());
				String cierre = W83bFactoriaDAO.getIncidenciasDAO().buscarCierre(incidenciasNueva,false);
				if(W83bClsConstantes.CONSTANTE_SI.equals(cierre)){
					if (result.equals("0"))
						result = "-8 "+incidencia.getNumIncidenciaCompleto();
					else
						result += ", "+incidencia.getNumIncidenciaCompleto();
				}
				else{
					String fechaValidacionAnterior = W83bFactoriaDAO.getIncidenciasDAO().validarFechaValidacionIncidenciaAnterior(incidenciasNueva);
					java.util.Date dateValidacionAnterior = null;
					Calendar calendarioDateValidacionAnterior = Calendar.getInstance();
					java.util.Date dateValidacion= W83bDateUtil.getInstance().stringToDateIdioma(incidenciasNueva.getFecValidacion(),incidenciasNueva.getIdioma());
					
					if(null!=fechaValidacionAnterior){
						dateValidacionAnterior = W83bDateUtil.getInstance().stringToDateIdioma(fechaValidacionAnterior,incidenciasNueva.getIdioma());
						calendarioDateValidacionAnterior.setTimeInMillis(dateValidacionAnterior.getTime());			
					}
					
					if(null!=dateValidacionAnterior&&calendarioDateValidacionAnterior.getTime().after(dateValidacion)){
						if (result.equals("0"))
							result = "-8 "+incidencia.getNumIncidenciaCompleto();
						else
							result += ", "+incidencia.getNumIncidenciaCompleto();				
					}
					else{
						List listaIncidencias = (ArrayList)W83bFactoriaDAO.getIncidenciasDAO().existeActaIncidenciaNoValidadaAnteriorReturnNIncidencia(incidenciasNueva);
						
						if(null!=listaIncidencias&&
								0<listaIncidencias.size()){
							for(int j=0,size2=listaIncidencias.size();j<size2;j++){
								HashMap mapa = (HashMap)listaIncidencias.get(j);
								
								StringBuffer numIncidencia = new StringBuffer(mapa.get(W83bIncidenciasBD.N_INCID_061).toString());//NOPMD
								while(6!=numIncidencia.length()){
									numIncidencia.insert(0, "0");			
								}
								
								String numIncidenciaCompleto = mapa.get(W83bIncidenciasBD.C_TERRIT_061).toString()+"/"+mapa.get(W83bIncidenciasBD.ANO_INCID_061).toString()+"/"+numIncidencia.toString();
								
								if(null==mapaIncidencias.get(numIncidenciaCompleto)){
									if (result.equals("0"))
										result = "-8 "+incidencia.getNumIncidenciaCompleto();
									else
										result += ", "+incidencia.getNumIncidenciaCompleto();							
								}		
								else
									mapaIncidencias.put(incidencia.getNumIncidenciaCompleto(), "true");
							}
						}
					}					
					
				}
		}
		
		for(int i = 0,size=listIncidencia.size();i<size;i++){
			W83bIncidenciasBean incidencia = (W83bIncidenciasBean)listIncidencia.get(i);//NOPMD
			W83bNuevaIncidenciasBean incidenciasNueva = new W83bNuevaIncidenciasBean();//NOPMD
			incidencia.setUsuarioBean(userBean);
			
			incidenciasNueva.setUsuarioBean(userBean);
			incidenciasNueva.setIncidenciaAnyo(incidencia.getAnyoIncidencia());
			incidenciasNueva.setIncidenciaNumero(incidencia.getNumIncidencia());
			incidenciasNueva.setIncidenciaTerritorio(incidencia.getTerritorioIncidencia());
			incidenciasNueva.setFecValidacion(incidencia.getFechaValidacion());
			incidenciasNueva.setIdioma(incidencia.getIdioma());
			incidenciasNueva.setValidada(W83bClsConstantes.CONSTANTE_VALIDADA);
			
			actualizarIncidenciaSimple(incidenciasNueva);	
//			System.out.println("Validando.... "+incidencia.getTerritorioIncidencia()+"/"+incidencia.getAnyoIncidencia()+"/"+incidencia.getNumIncidencia());
			
		}
		
		
		return result;
	}
/**
 * 20150520 metodo que valida masivamente incidencias
 */
public String validarFechaIncidencias(ArrayList listIncidencia, String resultado)throws Exception{
		
		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)listIncidencia.get(listIncidencia.size()-1);
		listIncidencia.remove(listIncidencia.size()-1);
		HashMap mapaIncidencias = new HashMap();
		ArrayList listIncidenciaAux= new ArrayList();
		for(int i = 0,size=listIncidencia.size();i<size;i++){
				W83bIncidenciasBean incidencia = (W83bIncidenciasBean)listIncidencia.get(i);//NOPMD
				W83bNuevaIncidenciasBean incidenciasNueva = new W83bNuevaIncidenciasBean();//NOPMD
				incidencia.setUsuarioBean(userBean);
				
				incidenciasNueva.setUsuarioBean(userBean);
				incidenciasNueva.setIncidenciaAnyo(incidencia.getAnyoIncidencia());
				incidenciasNueva.setIncidenciaNumero(incidencia.getNumIncidencia());
				incidenciasNueva.setIncidenciaTerritorio(incidencia.getTerritorioIncidencia());
				incidenciasNueva.setFecValidacion(incidencia.getFechaValidacion());
				incidenciasNueva.setIdioma(incidencia.getIdioma());
				incidenciasNueva.setValidada(W83bClsConstantes.CONSTANTE_VALIDADA);
				incidenciasNueva.setActaTerritorio(incidencia.getTerritorioActa());
				incidenciasNueva.setActaAnyo(incidencia.getAnyoActa());
				incidenciasNueva.setActaNumero(incidencia.getNumActaSencillo());
				
				String version = W83bFactoriaDAO.getIncidenciasDAO().maxVersionIncidenciaValidada(incidenciasNueva.getActaTerritorio(),incidenciasNueva.getActaAnyo(),incidenciasNueva.getActaNumero());
				incidenciasNueva.setActaVersion(version);
				
				//incidenciasNueva.setActaVersion(incidencia.getVersionActa());
				String cierre = W83bFactoriaDAO.getIncidenciasDAO().buscarCierre(incidenciasNueva,false);
				if(W83bClsConstantes.CONSTANTE_SI.equals(cierre)){
					if (resultado.equals(""))
						resultado ="ERROR <li>"+ incidencia.getNumIncidenciaCompleto()+"</li>";
					else
						resultado += "<li> "+incidencia.getNumIncidenciaCompleto()+"</li>";
				}
				else{
					String fechaValidacionAnterior = W83bFactoriaDAO.getIncidenciasDAO().validarFechaValidacionIncidenciaAnterior(incidenciasNueva);
					java.util.Date dateValidacionAnterior = null;
					Calendar calendarioDateValidacionAnterior = Calendar.getInstance();
					java.util.Date dateValidacion= W83bDateUtil.getInstance().stringToDateIdioma(incidenciasNueva.getFecValidacion(),incidenciasNueva.getIdioma());
					
					if(null!=fechaValidacionAnterior){
						dateValidacionAnterior = W83bDateUtil.getInstance().stringToDateIdioma(fechaValidacionAnterior,incidenciasNueva.getIdioma());
						calendarioDateValidacionAnterior.setTimeInMillis(dateValidacionAnterior.getTime());			
					}
					
					if(null!=dateValidacionAnterior&&calendarioDateValidacionAnterior.getTime().after(dateValidacion)){
						if (resultado.equals(""))
							resultado ="ERROR <li>"+ incidencia.getNumIncidenciaCompleto()+"</li>";
						else
							resultado += "<li>"+incidencia.getNumIncidenciaCompleto()+"</li>";			
					}
					else{
						List listaIncidencias = (ArrayList)W83bFactoriaDAO.getIncidenciasDAO().existeActaIncidenciaNoValidadaAnteriorReturnNIncidencia(incidenciasNueva);
						
						if(null!=listaIncidencias&&
								0<listaIncidencias.size()){
							boolean encontrado=false;
							for(int j=0,size2=listaIncidencias.size();j<size2;j++){
								
								HashMap mapa = (HashMap)listaIncidencias.get(j);
								
								StringBuffer numIncidencia = new StringBuffer(mapa.get(W83bIncidenciasBD.N_INCID_061).toString());//NOPMD
								while(6!=numIncidencia.length()){
									numIncidencia.insert(0, "0");			
								}
								
								String numIncidenciaCompleto = mapa.get(W83bIncidenciasBD.C_TERRIT_061).toString()+"/"+mapa.get(W83bIncidenciasBD.ANO_INCID_061).toString()+"/"+numIncidencia.toString();
								
								if(null==mapaIncidencias.get(numIncidenciaCompleto)){
									if (!encontrado){
										if (resultado.equals(""))
											resultado ="ERROR <li>"+ incidencia.getNumIncidenciaCompleto()+"</li>";
										else
											resultado += "<li>"+incidencia.getNumIncidenciaCompleto()+"</li>";		
										encontrado=true;
									}
								}	
							}
							if (!encontrado){
								listIncidenciaAux.add(incidencia);
							}
						}
						else
							listIncidenciaAux.add(incidencia);
						
						mapaIncidencias.put(incidencia.getNumIncidenciaCompleto(), "true");
					}					
					
				}
		}
		
		for(int i = 0,size=listIncidenciaAux.size();i<size;i++){
			W83bIncidenciasBean incidencia = (W83bIncidenciasBean)listIncidenciaAux.get(i);//NOPMD
			W83bNuevaIncidenciasBean incidenciasNueva = new W83bNuevaIncidenciasBean();//NOPMD
			incidencia.setUsuarioBean(userBean);
			
			incidenciasNueva.setUsuarioBean(userBean);
			incidenciasNueva.setIncidenciaAnyo(incidencia.getAnyoIncidencia());
			incidenciasNueva.setIncidenciaNumero(incidencia.getNumIncidencia());
			incidenciasNueva.setIncidenciaTerritorio(incidencia.getTerritorioIncidencia());
			incidenciasNueva.setFecValidacion(incidencia.getFechaValidacion());
			incidenciasNueva.setIdioma(incidencia.getIdioma());
			incidenciasNueva.setValidada(W83bClsConstantes.CONSTANTE_VALIDADA);
			
			actualizarIncidenciaSimple(incidenciasNueva);	
			
		}
		
		
		return resultado;
	}


	/**
	 * Actualiza la informacin de acuse de recibo de una lista de comunicaciones de incidencias
	 * @param listaComunicacionesAcuse List
	 * @throws Exception the exception
	 */
	public void actualizarDatosAcusesComunicacionIncidencias (ArrayList listaComunicacionesAcuse)throws Exception{
		//Recorremos las comunicaciones
		for (Iterator iter = listaComunicacionesAcuse.iterator(); iter.hasNext();) {
			W83bDocBean docBean = (W83bDocBean) iter.next();
			docBean.setCodTramite("2");
			docBean.setCodFase("6");
			W83bFactoriaDAO.getIncidenciasDAO().actualizarDatosAcuseComunicacion(docBean);
		}
	}


}